package com.bizunited.platform.user.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.service.UserMappingService;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户关联设置控制类，restfull风格接口
 * @Author: Paul Chan
 * @Date: 2019-11-25 16:58
 */
@RestController
@Api(tags = "用户关联设置控制类")
@RequestMapping("/v1/nebula/user/mapping")
public class UserMappingController extends BaseController {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(UserMappingController.class);

  @Autowired
  private UserMappingService userMappingService;

  /**
   * 用户关联设置
   * @param setting
   * @return
   */
  @PatchMapping("")
  @ApiOperation("更新用户关联设置")
  public ResponseModel update(@RequestBody UserMappingVo mappingVo) {
    try {
      UserMappingVo mapping = userMappingService.update(mappingVo);
      return buildHttpResultW(mapping);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 获取用户关联设置
   * @return
   */
  @GetMapping("")
  @ApiOperation("获取用户关联设置")
  public ResponseModel find() {
    try {
      UserMappingVo mapping = userMappingService.find();
      return buildHttpResultW(mapping);
    } catch (RuntimeException e) {
      return buildHttpResultForException(e);
    }
  }

}
