/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.web.starter.controller;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/orgs"})
public class OrganizationController
extends BaseController {
    @Autowired
    private OrganizationService organizationService;
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationController.class);

    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7\u673a\u6784")
    @PostMapping(value={""})
    public ResponseModel create(@ApiParam(name="\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f") @RequestBody OrganizationVo organization) {
        try {
            OrganizationVo organizationVo = this.organizationService.create(organization);
            return this.buildHttpResultW(organizationVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784")
    @PatchMapping(value={"/update"})
    public ResponseModel update(@ApiParam(name="\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f") @RequestBody OrganizationVo organizationEntity) {
        try {
            OrganizationVo organizationVo = this.organizationService.update(organizationEntity);
            return this.buildHttpResultW(organizationVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u72b6\u6001---(\u542f\u7528\u3001\u7981\u7528)")
    @PatchMapping(value={"/updateStatus/{orgId}"})
    public ResponseModel updateStatus(@PathVariable(value="orgId") String orgId) {
        LOGGER.debug("\u7ec4\u7ec7\u673a\u6784id:{}", (Object)orgId);
        try {
            OrganizationVo organization = this.organizationService.updateStatus(orgId);
            return this.buildHttpResultW(organization, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u4e00\u4e2a\u6307\u5b9a\u7684currentOrgId\u8fdb\u884c\u5176\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784parentOrgId\u7684\u7ed1\u5b9a\u64cd\u4f5c\uff08\u539f\u6709currentOrgId\u7684\u7236\u7ea7\u4fe1\u606f\u5c06\u4f1a\u88ab\u53d6\u6d88\uff09")
    @PatchMapping(value={"/bindParent"})
    public ResponseModel bindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="parentOrgId") @ApiParam(name="parentOrgId", value="\u5f53\u524d\u9700\u8981\u7ed1\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7") String parentOrgId) {
        try {
            this.organizationService.bindParent(currentOrgId, parentOrgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u4e00\u4e2a\u6307\u5b9a\u7684currentOrgId\u53d6\u6d88\u5176\u5f53\u524d\u7236\u7ea7\u5173\u7cfb\u7684\u7ed1\u5b9a\u4fe1\u606f")
    @PatchMapping(value={"/unbindParent"})
    public ResponseModel unbindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId) {
        try {
            this.organizationService.unbindParent(currentOrgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u670d\u52a1\u65b9\u6cd5\u53ef\u4ee5\u5728\u5ffd\u7565\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\uff08currentOrgId\uff09\u5df2\u7ed1\u5b9a\u7236\u7ea7\u673a\u6784\u7684\u60c5\u51b5\u4e0b\uff0c\u91cd\u65b0\u4e3a\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7ed1\u5b9a\u4e00\u4e2a\u65b0\u7684\u7236\u7ea7\u673a\u6784")
    @PatchMapping(value={"/reBindParent"})
    public ResponseModel reBindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="parentOrgId", required=false) @ApiParam(name="parentOrgId", value="\u5f53\u524d\u9700\u8981\u65b0\u7ed1\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7") String parentOrgId) {
        try {
            this.organizationService.reBindParent(currentOrgId, parentOrgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\uff08currentOrgId\uff09\u548c\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09\u5f62\u6210\u7ed1\u5b9a\u5173\u7cfb\u2014\u2014\u4e00\u4e2a\u7528\u6237\u53ea\u80fd\u5c5e\u4e8e\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784", notes="\u6ce8\u610f\uff0c\u76ee\u524d\u4e00\u4e2a\u4eba\u5458\u53ef\u4ee5\u548c\u591a\u4e2a\u7ec4\u7ec7\u673a\u6784\u8fdb\u884c\u7ed1\u5b9a\uff0c\u4f46\u662f\u5462\u4e00\u4e2a\u4eba\u5458\u6700\u591a\u53ea\u80fd\u548c\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784\u7ed1\u5b9a\u4e00\u6b21")
    @RequestMapping(value={"/bindUsers"}, method={RequestMethod.PATCH})
    public ResponseModel bindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="userIds") @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.organizationService.bindUsers(currentOrgId, userIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u7528\u6237\u548c\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @RequestMapping(value={"/unbindUsers"}, method={RequestMethod.PATCH})
    public ResponseModel unbindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5e93\u7f16\u53f7") String currentOrgId, @RequestParam(name="userId") @ApiParam(name="userId", value="\u5f53\u524d\u9700\u8981\u64cd\u4f5c\u7684\u4eba\u5458id\u4fe1\u606f\uff08\u591a\u4e2a\uff09") String[] userId) {
        try {
            this.organizationService.unbindUsers(currentOrgId, userId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u7ed1\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u7528\u6237")
    @PatchMapping(value={"rebindUsers"})
    public ResponseModel rebindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="userIds", required=false) @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.organizationService.rebindUsers(currentOrgId, userIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u6ca1\u6709\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff08\u67e5\u8be2\u6240\u6709\u6839\u8282\u70b9\u7ec4\u7ec7\u673a\u6784\uff09\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByNullParent"}, method={RequestMethod.GET})
    public ResponseModel findByNullParent() {
        try {
            List resutls = this.organizationService.findByNullParent();
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByParent"}, method={RequestMethod.GET})
    public ResponseModel findByParent(@RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784id") String parentId) {
        try {
            List resutls = this.organizationService.findByParent(parentId);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findTreeByConditions"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u6811\u7ed3\u6784", notes="\u8fd4\u56de\u7684\u6570\u636e\uff0c\u9664\u4e86\u8fd4\u56de\u5339\u914d\u7684\u6570\u636e\u5916\uff0c\u8fd8\u5305\u542b\u5339\u914d\u6570\u636e\u7684\u6240\u6709\u4e0a\u7ea7")
    public ResponseModel findTreeByConditions(@RequestParam(required=false) @ApiParam(value="id") String id, @RequestParam(required=false) @ApiParam(value="\u7f16\u7801") String code, @RequestParam(required=false) @ApiParam(value="\u540d\u79f0") String orgName, @RequestParam(required=false) @ApiParam(value="\u72b6\u6001") Integer tstatus) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("id", id);
            parameters.put("code", code);
            parameters.put("orgName", orgName);
            parameters.put("tstatus", tstatus);
            List resutls = this.organizationService.findTreeByConditions(parameters);
            return this.buildHttpResultW(resutls, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u6ca1\u6709\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u5e76\u4e14\u4f9d\u636e\u5176\u72b6\u6001\u8fdb\u884c\u67e5\u8be2", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByNullParentAndStatus"}, method={RequestMethod.GET})
    public ResponseModel findByNullParentAndStatus(@RequestParam(name="status") @ApiParam(name="status", value="\u72b6\u6001\u4fe1\u606f\uff081:\u6b63\u5e38\uff1b0\u7981\u7528/\u5f02\u5e38\uff09") Integer status) {
        try {
            List resutls = this.organizationService.findByNullParentAndStatus(status);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u5e76\u4e14\u4f9d\u636e\u5176\u72b6\u6001\u8fdb\u884c\u67e5\u8be2", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByParentAndStatus"}, method={RequestMethod.GET})
    public ResponseModel findByParentAndStatus(@RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784id") String parentId, @RequestParam(name="status") @ApiParam(name="status", value="\u72b6\u6001\u4fe1\u606f\uff081:\u6b63\u5e38\uff1b0\u7981\u7528/\u5f02\u5e38\uff09") Integer status) {
        try {
            List resutls = this.organizationService.findByParentAndStatus(parentId, status);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u8fd9\u4e9b\u7ec4\u7ec7\u673a\u6784\uff09\u5bf9\u5e94\u7684\u6240\u6709\u7236\u7ea7\u3001\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @RequestMapping(value={"/findByOrgName"}, method={RequestMethod.GET})
    public ResponseModel findByOrgName(@RequestParam(name="orgName") @ApiParam(name="orgName", value="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4fe1\u606f") String orgName) {
        try {
            JSONArray resutls = this.organizationService.findByOrgName(orgName);
            return this.buildHttpResultW((Iterable)resutls, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a\u5305\u62ec\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(name="id") @ApiParam(name="id", value="\u7ec4\u7ec7\u673a\u6784id") String id) {
        try {
            OrganizationVo organization = this.organizationService.findDetailsById(id);
            return this.buildHttpResultW(organization, new String[]{"parent", "child", "users", "positions"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u8fd9\u4e9b\u7ec4\u7ec7\u673a\u6784\uff09\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @RequestMapping(value={"/findUnbindOrgById"}, method={RequestMethod.GET})
    public ResponseModel findUnbindOrgById(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784") String currentOrgId) {
        try {
            Object[] resutls = this.organizationService.findUnbindOrgById(currentOrgId);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            List resutls = this.organizationService.findAll();
            return this.buildHttpResultW(resutls, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findMainOrgByUserId"})
    public ResponseModel findMainOrgByUserId(@RequestParam @ApiParam(value="\u7528\u6237ID") String userId) {
        try {
            OrganizationVo org = this.organizationService.findMainOrgByUserId(userId);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f")
    @RequestMapping(value={"/findOrgByUserId"}, method={RequestMethod.GET})
    public ResponseModel findOrgByUserId(@ApiParam(name="userId", value="\u7528\u6237id\u4fe1\u606f") @RequestParam(value="userId") String userId) {
        try {
            Set org = this.organizationService.findOrgByUserId(userId);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f")
    @RequestMapping(value={"/findByIds"}, method={RequestMethod.POST})
    public ResponseModel findByIds(@RequestBody List<String> ids) {
        try {
            Set org = this.organizationService.findByIds(ids);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784-\u6811\u7ed3\u6784\u67e5\u8be2-\u6839\u636e\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784ID\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public ResponseModel findById(@RequestParam(value="id") @ApiParam(name="id", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784Id") String id) {
        try {
            OrganizationVo result = this.organizationService.findById(id);
            return this.buildHttpResultW(result, new String[]{"child"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784-\u6811\u7ed3\u6784\u67e5\u8be2-\u6839\u636e\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784ids\u6216\u8005\u7f16\u7801\u96c6\u5408(\u5fc5\u4f20\u4efb\u4e00)\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @GetMapping(value={"/findChildrenByIdsOrCodes"})
    public ResponseModel findChildrenByIdsOrCodes(@RequestParam(value="ids", required=false) @ApiParam(name="ids", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784Ids") String[] ids, @RequestParam(value="codes", required=false) @ApiParam(name="codes", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u96c6\u5408") String[] codes) {
        try {
            List result = this.organizationService.findChildrenByIdsOrCodes(ids, codes);
            return this.buildHttpResultW(result, new String[]{"child"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784-\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u5b9e\u73b0\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/findByOrgNameLike"})
    public ResponseModel findByOrgNameLike(@RequestParam(name="orgName") @ApiParam(name="orgName", value="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0") String orgName) {
        try {
            Set organization = this.organizationService.findByOrgNameLike(orgName);
            return this.buildHttpResultW(organization, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCode"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2")
    public ResponseModel findByCode(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801") String code) {
        try {
            OrganizationVo org = this.organizationService.findByCode(code);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7528\u6237\u6240\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f(\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)\uff0c\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f")
    @GetMapping(value={"/findByUserId"})
    public ResponseModel findByUserId(@RequestParam(name="userId") String userId) {
        try {
            JSONArray org = this.organizationService.findByUserId(userId);
            return this.buildHttpResultW((Iterable)org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByChild"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2")
    public ResponseModel findByChild(@RequestParam(name="childId") String childId) {
        try {
            OrganizationVo org = this.organizationService.findByChild(childId);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"updateUserMainOrg"})
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u7684\u4e3b\u7ec4\u7ec7\u673a\u6784")
    public ResponseModel updateUserMainOrg(@RequestParam @ApiParam(value="\u7528\u6237ID") String userId, @RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") String orgId) {
        try {
            this.organizationService.updateUserMainOrg(userId, orgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByPrincipal"})
    @ApiOperation(value="\u6839\u636e\u767b\u9646\u4eba\u5173\u8054\u7684\u7ec4\u7ec7\u67e5\u8be2\u63a7\u4ef6")
    public ResponseModel findByPrincipal(@RequestParam(required=true) @ApiParam(value="\u7c7b\u578b, 1:\u5173\u8054\u7ec4\u7ec7\u4e0a\u7ea7, 2\uff1a\u5173\u8054\u7ec4\u7ec7\u4e0b\u7ea7, 3\uff1a\u5173\u8054\u7ec4\u7ec7\u4e0a\u4e0b\u7ea7, 4\uff1a\u5173\u8054\u7ec4\u7ec7") Integer type) {
        try {
            Principal principal = this.getPrincipal();
            Set orgs = this.organizationService.findByPrincipal(type, principal);
            return this.buildHttpResult(orgs);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByTypeAndLevel"})
    @ApiOperation(value="\u6839\u636e\u767b\u9646\u4eba\u5173\u8054\u7684\u7ec4\u7ec7\u548c\u8f93\u5165\u5c42\u7ea7\u67e5\u8be2\u63a7\u4ef6")
    public ResponseModel findByTypeAndLevel(@RequestParam(required=true) @ApiParam(value="\u7c7b\u578b, 1:\u7ec4\u7ec7\u4e0a\u7ea7, 2\uff1a\u7ec4\u7ec7\u4e0b\u7ea7") Integer type, @RequestParam(required=true) @ApiParam(value="\u5c42\u7ea7") Integer level) {
        try {
            Principal principal = this.getPrincipal();
            String account = principal.getName();
            Set orgs = this.organizationService.findByTypeAndLevel(type, account, level);
            return this.buildHttpResult(orgs);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

