/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="UserController")
@RestController
@RequestMapping(value={"/v1/nebula/users"})
public class UserController
extends BaseController {
    @Autowired
    private UserService userService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserController.class);

    @ApiOperation(value="\u6dfb\u52a0\u4e00\u4e2a\u65b0\u7684\u7528\u6237\u4fe1\u606f\uff08\u540e\u53f0\u7ba1\u7406\u4eba\u5458\uff0c\u4e1a\u52a1\u529f\u80fd\u64cd\u4f5c\u8005\uff09", notes="")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="user", value="\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", required=true) @RequestBody UserVo user) {
        try {
            UserVo currentPoliceMan = this.userService.create(user);
            return this.buildHttpResultW(currentPoliceMan, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6307\u5b9a\u7528\u6237\u7684\u5bc6\u7801\u4fe1\u606f")
    @PostMapping(value={"/updatePassword"})
    public ResponseModel updatePassword(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237", required=true) @RequestParam(name="userId", required=true) String userId, @ApiParam(name="newPassword", value="\u65b0\u7684\u5bc6\u7801\uff08\u6ca1\u6709\u52a0\u5bc6\u7684\uff09", required=true) @RequestParam(name="newPassword", required=true) String newPassword) {
        try {
            UserVo currentUser = this.userService.updatePassword(userId, newPassword);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u7528\u6237\u4fe1\u606f", notes="\u53ef\u4ee5\u4fee\u6539\u7684\u5305\u62ec\u5c5e\u6027\u53ea\u6709\uff1a<br>\u7528\u6237\u771f\u5b9e\u59d3\u540d\u3001\u7528\u6237\u5934\u50cf\u4fe1\u606f\u3001\u5165\u804c\u65f6\u95f4\u3001\u8054\u7cfb\u7535\u8bdd\u3001\u6027\u522b\uff080\u4fdd\u5bc6\uff0c1\u7537  2\u5973\uff09")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="user", value="\u4ee5\u5bf9\u8c61\u65b9\u5f0f\u4f20\u5165\u7684\u9700\u8981\u4fee\u6539\u7684\u5c5e\u6027\uff0c\u4e0d\u80fd\u4fee\u6539\u7684\u5c5e\u6027\u5373\u4f7f\u4f20\u5165\u8be5\u5c5e\u6027\u4e5f\u4e0d\u4f1a\u53d1\u751f\u53d8\u5316", required=true) @RequestBody UserVo user) {
        try {
            UserVo currentUser = this.userService.update(user);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u6307\u5b9a\u7528\u6237\u7684\u5bc6\u7801\u4fe1\u606f")
    @RequestMapping(value={"/updatePassword"}, method={RequestMethod.PATCH})
    public ResponseModel updatePassword(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237", required=true) String userId, @ApiParam(name="oldPassword", value="\u539f\u59cb\u5bc6\u7801\uff08\u6ca1\u6709\u52a0\u5bc6\u7684\uff09", required=true) String oldPassword, @ApiParam(name="newPassword", value="\u65b0\u7684\u5bc6\u7801\uff08\u6ca1\u6709\u52a0\u5bc6\u7684\uff09", required=true) String newPassword) {
        try {
            UserVo currentUser = this.userService.updatePassword(userId, newPassword, oldPassword);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u6307\u5b9a\u7528\u6237\u7684\u5bc6\u7801\u4fe1\u606f\uff08\u5ffd\u7565\u539f\u59cb\u5bc6\u7801\uff0c\u8be5\u65b9\u6cd5\u4e00\u822c\u7531\u7ba1\u7406\u5458\u4f7f\u7528\uff09")
    @RequestMapping(value={"/updatePasswordIgnoreOld"}, method={RequestMethod.PATCH})
    public ResponseModel updatePasswordIgnoreOld(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237", required=true) String userId, @ApiParam(name="newPassword", value="\u65b0\u7684\u5bc6\u7801\uff08\u6ca1\u6709\u52a0\u5bc6\u7684\uff09", required=true) String newPassword) {
        try {
            UserVo currentUser = this.userService.updatePassword(userId, newPassword);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\u7684\u72b6\u6001\uff0c\u5305\u62ec\u53ef\u7528\u72b6\u6001\u548c\u4e0d\u53ef\u7528\u72b6\u6001")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatus(@ApiParam(name="account", value="\u6307\u5b9a\u7684\u65b0\u7684\u7528\u6237\u8d26\u53f7", required=true) String account, @ApiParam(name="flag", value="\u6307\u5b9a\u7684\u65b0\u7684\u72b6\u6001", required=true) boolean flag) {
        try {
            if (flag) {
                this.userService.enabled(account);
            } else {
                this.userService.disable(account);
            }
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7528\u6237\u542f\u7528")
    @PatchMapping(value={"/enabled"})
    public ResponseModel enabled(@ApiParam(name="account", value="\u6307\u5b9a\u7684\u65b0\u7684\u7528\u6237\u8d26\u53f7", required=true) String account) {
        try {
            this.userService.enabled(account);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7528\u6237\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public ResponseModel disable(@ApiParam(name="account", value="\u6307\u5b9a\u7684\u65b0\u7684\u7528\u6237\u8d26\u53f7", required=true) String account) {
        try {
            this.userService.disable(account);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6210\u529f\u767b\u9646\u540e\uff0c\u66f4\u65b0\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u65f6\u95f4")
    @PatchMapping(value={"/updateLastloginTime"})
    public ResponseModel updateLastloginTime(@ApiParam(name="account", value="\u6307\u5b9a\u7684\u65b0\u7684\u7528\u6237\u8d26\u53f7", required=true) String account) {
        try {
            this.userService.updateLastloginTime(account);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u4e14\u5305\u62ec\u5f53\u524d\u7528\u6237\u76f4\u63a5\u7ed1\u5b9a\u7684\u7528\u6237\u7ec4\u3001\u7ec4\u7ec7\u673a\u6784\u548c\u5c97\u4f4d\u4fe1\u606f\u3002\u4f46\u662f\u4e0d\u5305\u62ec\u7528\u6237\u89d2\u8272\uff0c\u56e0\u4e3a\u7528\u6237\u89d2\u8272\u9700\u8981\u5355\u72ec\u67e5")
    @RequestMapping(value={"/{userId}"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237\u7f16\u53f7", required=true) @PathVariable(value="userId") String userId) {
        try {
            UserVo currentUser = this.userService.findDetailsById(userId);
            return this.buildHttpResultW(currentUser, new String[]{"positions", "groups", "orgs"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f(\u6309\u7167\u7528\u6237\u8d26\u53f7\u67e5\u8be2)\uff0c\u4e0d\u5305\u62ec\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\uff08\u5305\u62ec\u95f4\u63a5\u7ed1\u5b9a\uff09\u7684\u89d2\u8272\u4fe1\u606f\u3001\u7528\u6237\u7ec4\u3001\u7ec4\u7ec7\u673a\u6784\u548c\u5c97\u4f4d")
    @RequestMapping(value={"/findByAccount"}, method={RequestMethod.GET})
    public ResponseModel findByAccount(@ApiParam(name="account", value="\u6307\u5b9a\u7684\u7528\u6237\u8d26\u6237\uff08\u80af\u5b9a\u662f\u552f\u4e00\u7684\uff09") @RequestParam(value="account") String account) {
        try {
            UserVo currentUser = this.userService.findByAccount(account);
            return this.buildHttpResultW(currentUser, new String[]{"positions", "groups", "orgs"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5df2\u767b\u5f55\u7684\u64cd\u4f5c\u8005\u4fe1\u606f(\u6309\u7167\u7528\u6237\u8d26\u53f7\u67e5\u8be2)\uff0c\u4e0d\u5305\u62ec\u5f53\u524d\u64cd\u4f5c\u8005\u5df2\u7ecf\u7ed1\u5b9a\uff08\u5305\u62ec\u95f4\u63a5\u7ed1\u5b9a\uff09\u7684\u89d2\u8272\u4fe1\u606f\u3001\u7528\u6237\u7ec4\u3001\u7ec4\u7ec7\u673a\u6784\u548c\u5c97\u4f4d")
    @RequestMapping(value={"/findByPrincipal"}, method={RequestMethod.GET})
    public ResponseModel findByPrincipal(HttpServletRequest request, HttpServletResponse response) {
        try {
            Principal op = this.getPrincipal();
            UserVo currentUser = this.userService.findByAccount(op.getName());
            HttpSession session = request.getSession();
            String jsession = session.getId();
            response.addHeader("JSESSIONID", jsession);
            response.addHeader("persistence", jsession);
            response.addHeader("Access-Control-Expose-Headers", "JSESSIONID,persistence");
            return this.buildHttpResultW(currentUser, new String[]{"positions", "groups", "orgs"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u6682\u65f6\u67e5\u8be2\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u57fa\u7840\u4fe1\u606f")
    @RequestMapping(value={"/findByUserId"}, method={RequestMethod.GET})
    public ResponseModel findByUserId(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237id\u4fe1\u606f") @RequestParam(value="userId") String userId) {
        try {
            UserVo creator = this.userService.findByUserId(userId);
            return this.buildHttpResultW(creator, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u7528\u6237\uff0c\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(name="userVo", value="\u7528\u6237\u4fe1\u606f") UserVo userVo, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page page = this.userService.findByConditions(userVo, pageable);
            return this.buildHttpResultW(page, new String[]{"roles"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u7528\u6237\u4fe1\u606f\uff08\u53ea\u5305\u62ec\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f\uff09")
    @RequestMapping(value={"/findByIds"}, method={RequestMethod.POST})
    public ResponseModel findByIds(@RequestBody List<String> ids) {
        try {
            Set users = this.userService.findByIds(ids);
            return this.buildHttpResultW(users, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u4e0e\u540d\u79f0\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findByAccountLikeOrNameLike"}, method={RequestMethod.GET})
    public ResponseModel findByAccountLikeOrNameLike(@RequestParam(value="param") String param) {
        try {
            List users = this.userService.findByAccountLikeOrNameLike(param);
            return this.buildHttpResultW(users, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u624b\u673a\u53f7\uff0c\u67e5\u8be2\u8d26\u6237\u57fa\u672c\u4fe1\u606f\uff0c\u8be5\u65b9\u6cd5\u7684\u67e5\u8be2\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff0c\u4f8b\u5982\u89d2\u8272\u4fe1\u606f\u3002")
    @GetMapping(value={"/findByPhone"})
    public ResponseModel findByPhone(@RequestParam(value="phone") String phone) {
        try {
            UserVo user = this.userService.findByPhone(phone);
            return this.buildHttpResultW(user, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByOrgId"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784ID\u67e5\u8be2\u7ed1\u5b9a\u7684\u7528\u6237")
    public ResponseModel findByOrgId(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") String orgId) {
        try {
            Set users = this.userService.findByOrgId(orgId);
            return this.buildHttpResultW(users, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByPositionId"})
    @ApiOperation(value="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u7ed1\u5b9a\u7684\u7528\u6237")
    public ResponseModel findByPositionId(@RequestParam @ApiParam(value="\u5c97\u4f4d\u7f16\u7801") String positionId) {
        try {
            Set users = this.userService.findByPositionId(positionId);
            return this.buildHttpResultW(users, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

