/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.service.region.AdministrativeRegionService;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/regions"})
public class AdministrativeRegionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdministrativeRegionController.class);
    @Autowired
    private AdministrativeRegionService administrativeRegionService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u884c\u653f\u533a\u57df")
    public ResponseModel create(@RequestBody AdministrativeRegionVo region) {
        try {
            AdministrativeRegionVo dbRegion = this.administrativeRegionService.create(region);
            return this.buildHttpResultW(dbRegion, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"updateOrgMappingLevel"})
    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u5173\u8054\u5c42\u7ea7", notes="\u5173\u8054\u5c42\u7ea7:1\u3001\u7701 2\u3001\u5e02 3\u3001\u533a\u53bf")
    public ResponseModel updateOrgMappingLevel(@RequestParam @ApiParam(value="\u5173\u8054\u5c42\u7ea7") Integer level) {
        try {
            this.administrativeRegionService.updateOrgMappingLevel(level);
            return this.buildHttpResultW(level, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findOrgMappingLevel"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5173\u8054\u5c42\u7ea7")
    public ResponseModel findOrgMappingLevel() {
        try {
            Integer level = this.administrativeRegionService.findOrgMappingLevel();
            return this.buildHttpResultW(level, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167AdministrativeRegionEntity\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            AdministrativeRegionVo result = this.administrativeRegionService.findDetailsById(id);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167AdministrativeRegionEntity\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\uff0c\u4e0d\u5e26\u51fa\u660e\u7ec6\u8bb0\u5f55\u3002")
    @GetMapping(value={"/findById"})
    public ResponseModel findById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            AdministrativeRegionVo result = this.administrativeRegionService.findById(id);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u5408\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@RequestParam(required=false) @ApiParam(value="\u533a\u57df\u540d\u79f0") String regionName, @RequestParam(required=false) @ApiParam(value="\u533a\u57df\u7f16\u7801") String regionCode, @RequestParam(required=false) @ApiParam(value="\u7ecf\u5ea6") String longitude, @RequestParam(required=false) @ApiParam(value="\u7eac\u5ea6") String latitude) {
        try {
            HashMap<String, String> conditions = new HashMap<String, String>();
            conditions.put("regionName", regionName);
            conditions.put("regionCode", regionCode);
            conditions.put("longitude", longitude);
            conditions.put("latitude", latitude);
            List regionVos = this.administrativeRegionService.findByConditions(conditions);
            return this.buildHttpResult(regionVos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5c42\u7ea7\u67e5\u8be2,\u7ed3\u679c\u4e0d\u5305\u542b\u4efb\u4f55\u7236\u5b50\u5173\u7cfb")
    @GetMapping(value={"/findByRegionLevel"})
    public ResponseModel findByRegionLevel(@RequestParam(value="regionLevel") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") Integer regionLevel) {
        try {
            Set regionVos = this.administrativeRegionService.findByRegionLevel(regionLevel);
            return this.buildHttpResult(regionVos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByOrgId"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u67e5\u8be2\u5173\u8054\u7684\u884c\u653f\u533a\u57df")
    public ResponseModel findByOrgId(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") String orgId) {
        try {
            List regions = this.administrativeRegionService.findByOrgId(orgId);
            return this.buildHttpResultW(regions, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByParent"})
    @ApiOperation(value="\u6839\u636e\u7236ID\u67e5\u8be2\u5b50\u533a\u57df", notes="\u5982\u679c\u4e0d\u4f20\u7236ID\uff0c\u5219\u8fd4\u56de\u6700\u9876\u5c42\u7684\u533a\u57df")
    public ResponseModel findByParent(@RequestParam(required=false) @ApiParam(value="\u7236\u7ea7ID\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String parentId) {
        try {
            List regions = this.administrativeRegionService.findByParent(parentId);
            return this.buildHttpResultW(regions, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCode"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u884c\u653f\u533a\u57df")
    public ResponseModel findByCode(@RequestParam @ApiParam(value="\u533a\u57df\u7f16\u7801") String code) {
        try {
            AdministrativeRegionVo region = this.administrativeRegionService.findByCode(code);
            return this.buildHttpResultW(region, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }
}

