/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.web.starter.controller;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/orgs"})
public class OrganizationController
extends BaseController {
    @Autowired
    private OrganizationService organizationService;
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationController.class);

    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7\u673a\u6784")
    @PostMapping
    public ResponseModel create(@ApiParam(name="\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f") @RequestBody OrganizationVo organization) {
        try {
            OrganizationVo organizationVo = this.organizationService.create(organization);
            return this.buildHttpResultW(organizationVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784")
    @PatchMapping(value={"/update"})
    public ResponseModel update(@ApiParam(name="\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f") @RequestBody OrganizationVo organizationEntity) {
        try {
            OrganizationVo organizationVo = this.organizationService.update(organizationEntity);
            return this.buildHttpResultW(organizationVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u72b6\u6001---(\u542f\u7528\u3001\u7981\u7528)")
    @PatchMapping(value={"/updateStatus/{orgId}"})
    public ResponseModel updateStatus(@PathVariable(value="orgId") String orgId) {
        LOGGER.debug("\u7ec4\u7ec7\u673a\u6784id:{}", (Object)orgId);
        try {
            OrganizationVo organization = this.organizationService.updateStatus(orgId);
            return this.buildHttpResultW(organization, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u72b6\u6001---(\u542f\u7528)")
    @PatchMapping(value={"/enables"})
    public ResponseModel enables(@RequestParam(name="ids") String[] ids) {
        try {
            Set organizations = this.organizationService.enables(ids);
            return this.buildHttpResultW(organizations, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u72b6\u6001---(\u7981\u7528)")
    @PatchMapping(value={"/disables"})
    public ResponseModel disables(@RequestParam(name="ids") String[] ids) {
        try {
            Set organizations = this.organizationService.disables(ids);
            return this.buildHttpResultW(organizations, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u4e00\u4e2a\u6307\u5b9a\u7684currentOrgId\u8fdb\u884c\u5176\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784parentOrgId\u7684\u7ed1\u5b9a\u64cd\u4f5c\uff08\u539f\u6709currentOrgId\u7684\u7236\u7ea7\u4fe1\u606f\u5c06\u4f1a\u88ab\u53d6\u6d88\uff09")
    @PatchMapping(value={"/bindParent"})
    public ResponseModel bindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="parentOrgId") @ApiParam(name="parentOrgId", value="\u5f53\u524d\u9700\u8981\u7ed1\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7") String parentOrgId) {
        try {
            this.organizationService.bindParent(currentOrgId, parentOrgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u4e00\u4e2a\u6307\u5b9a\u7684currentOrgId\u53d6\u6d88\u5176\u5f53\u524d\u7236\u7ea7\u5173\u7cfb\u7684\u7ed1\u5b9a\u4fe1\u606f")
    @PatchMapping(value={"/unbindParent"})
    public ResponseModel unbindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId) {
        try {
            this.organizationService.unbindParent(currentOrgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u670d\u52a1\u65b9\u6cd5\u53ef\u4ee5\u5728\u5ffd\u7565\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\uff08currentOrgId\uff09\u5df2\u7ed1\u5b9a\u7236\u7ea7\u673a\u6784\u7684\u60c5\u51b5\u4e0b\uff0c\u91cd\u65b0\u4e3a\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7ed1\u5b9a\u4e00\u4e2a\u65b0\u7684\u7236\u7ea7\u673a\u6784")
    @PatchMapping(value={"/reBindParent"})
    public ResponseModel reBindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="parentOrgId", required=false) @ApiParam(name="parentOrgId", value="\u5f53\u524d\u9700\u8981\u65b0\u7ed1\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7") String parentOrgId) {
        try {
            this.organizationService.rebindParent(currentOrgId, parentOrgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\uff08currentOrgId\uff09\u548c\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09\u5f62\u6210\u7ed1\u5b9a\u5173\u7cfb\u2014\u2014\u4e00\u4e2a\u7528\u6237\u53ea\u80fd\u5c5e\u4e8e\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784", notes="\u6ce8\u610f\uff0c\u76ee\u524d\u4e00\u4e2a\u4eba\u5458\u53ef\u4ee5\u548c\u591a\u4e2a\u7ec4\u7ec7\u673a\u6784\u8fdb\u884c\u7ed1\u5b9a\uff0c\u4f46\u662f\u5462\u4e00\u4e2a\u4eba\u5458\u6700\u591a\u53ea\u80fd\u548c\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784\u7ed1\u5b9a\u4e00\u6b21")
    @PatchMapping(value={"/bindUsers"})
    public ResponseModel bindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="userIds") @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.organizationService.bindUsers(currentOrgId, userIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u7528\u6237\u548c\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindUsers"})
    public ResponseModel unbindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5e93\u7f16\u53f7") String currentOrgId, @RequestParam(name="userId") @ApiParam(name="userId", value="\u5f53\u524d\u9700\u8981\u64cd\u4f5c\u7684\u4eba\u5458id\u4fe1\u606f\uff08\u591a\u4e2a\uff09") String[] userId) {
        try {
            this.organizationService.unbindUsers(currentOrgId, userId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u7ed1\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u7528\u6237")
    @PatchMapping(value={"rebindUsers"})
    public ResponseModel rebindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="userIds", required=false) @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.organizationService.rebindUsers(currentOrgId, userIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"bindRegions"})
    @ApiOperation(value="\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df")
    public ResponseModel bindRegions(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") String orgId, @RequestParam @ApiParam(value="\u884c\u653f\u533a\u57dfID\u96c6\u5408") String[] regionIds) {
        try {
            this.organizationService.bindRegions(orgId, regionIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"rebindRegions"})
    @ApiOperation(value="\u91cd\u65b0\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df")
    public ResponseModel rebindRegions(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") String orgId, @RequestParam @ApiParam(value="\u884c\u653f\u533a\u57dfID\u96c6\u5408") String[] regionIds) {
        try {
            this.organizationService.rebindRegions(orgId, regionIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"unbindRegions"})
    @ApiOperation(value="\u89e3\u7ed1\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u884c\u653f\u533a\u57df")
    public ResponseModel unbindRegion(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") String orgId, @RequestParam @ApiParam(value="\u884c\u653f\u533a\u57dfID\u96c6\u5408") String[] regionIds) {
        try {
            this.organizationService.unbindRegions(orgId, regionIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u6ca1\u6709\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff08\u67e5\u8be2\u6240\u6709\u6839\u8282\u70b9\u7ec4\u7ec7\u673a\u6784\uff09\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"/findByNullParent"})
    public ResponseModel findByNullParent() {
        try {
            List results = this.organizationService.findByNullParent();
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"/findByParent"})
    public ResponseModel findByParent(@RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784id") String parentId) {
        try {
            List results = this.organizationService.findByParent(parentId);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u6240\u6709\u641c\u7d22\u540d\u79f0\u6761\u4ef6\u7684\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"/findByParentAndFilterConditions"})
    public ResponseModel findByParentAndFilterConditions(@RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784id") String parentId, @RequestParam(required=false) @ApiParam(value="id") String id, @RequestParam(required=false) @ApiParam(value="\u7f16\u7801") String code, @RequestParam(required=false) @ApiParam(value="\u540d\u79f0") String orgName) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("parentId", parentId);
            parameters.put("id", id);
            parameters.put("code", code);
            parameters.put("orgName", orgName);
            InvokeParams invokeParams = new InvokeParams(parameters);
            List results = this.organizationService.findByParentAndFilterConditions(invokeParams);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u6811\u7ed3\u6784", notes="\u8fd4\u56de\u7684\u6570\u636e\uff0c\u9664\u4e86\u8fd4\u56de\u5339\u914d\u7684\u6570\u636e\u5916\uff0c\u8fd8\u5305\u542b\u5339\u914d\u6570\u636e\u7684\u6240\u6709\u4e0a\u7ea7")
    @GetMapping(value={"findTreeByConditions"})
    public ResponseModel findTreeByConditions(@RequestParam(required=false) @ApiParam(value="id") String id, @RequestParam(required=false) @ApiParam(value="\u7f16\u7801") String code, @RequestParam(required=false) @ApiParam(value="\u540d\u79f0") String orgName, @RequestParam(required=false) @ApiParam(value="\u72b6\u6001") Integer tstatus) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("id", id);
            parameters.put("code", code);
            parameters.put("orgName", orgName);
            parameters.put("tstatus", tstatus);
            InvokeParams invokeParams = new InvokeParams(parameters);
            List results = this.organizationService.findTreeByConditions(invokeParams);
            return this.buildHttpResultW(results, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u6ca1\u6709\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u5e76\u4e14\u4f9d\u636e\u5176\u72b6\u6001\u8fdb\u884c\u67e5\u8be2", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"/findByNullParentAndStatus"})
    public ResponseModel findByNullParentAndStatus(@RequestParam(name="status") @ApiParam(name="status", value="\u72b6\u6001\u4fe1\u606f\uff081:\u6b63\u5e38\uff1b0\u7981\u7528/\u5f02\u5e38\uff09") Integer status) {
        try {
            List results = this.organizationService.findByNullParentAndStatus(status);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u5e76\u4e14\u4f9d\u636e\u5176\u72b6\u6001\u8fdb\u884c\u67e5\u8be2", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"/findByParentAndStatus"})
    public ResponseModel findByParentAndStatus(@RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784id") String parentId, @RequestParam(name="status") @ApiParam(name="status", value="\u72b6\u6001\u4fe1\u606f\uff081:\u6b63\u5e38\uff1b0\u7981\u7528/\u5f02\u5e38\uff09") Integer status) {
        try {
            List results = this.organizationService.findByParentAndStatus(parentId, status);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u8fd9\u4e9b\u7ec4\u7ec7\u673a\u6784\uff09\u5bf9\u5e94\u7684\u6240\u6709\u7236\u7ea7\u3001\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @GetMapping(value={"/findByOrgName"})
    public ResponseModel findByOrgName(@RequestParam(name="orgName") @ApiParam(name="orgName", value="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4fe1\u606f") String orgName) {
        try {
            JSONArray results = this.organizationService.findByOrgName(orgName);
            return this.buildHttpResultW((Iterable)results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a\u5305\u62ec\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(name="id") @ApiParam(name="id", value="\u7ec4\u7ec7\u673a\u6784id") String id) {
        try {
            OrganizationVo organization = this.organizationService.findDetailsById(id);
            return this.buildHttpResultW(organization, new String[]{"parent", "child", "users", "positions"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u8fd9\u4e9b\u7ec4\u7ec7\u673a\u6784\uff09\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @GetMapping(value={"/findUnbindOrgById"})
    public ResponseModel findUnbindOrgById(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784") String currentOrgId) {
        try {
            Object[] results = this.organizationService.findUnbindOrgById(currentOrgId);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"/findAll"})
    public ResponseModel findAll() {
        try {
            List results = this.organizationService.findAll();
            return this.buildHttpResultW(results, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7684\u4e3b\u7ec4\u7ec7\u673a\u6784")
    @GetMapping(value={"findMainOrgByUserId"})
    public ResponseModel findMainOrgByUserId(@RequestParam @ApiParam(value="\u7528\u6237ID") String userId) {
        try {
            OrganizationVo org = this.organizationService.findMainOrgByUserId(userId);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/findOrgByUserId"})
    public ResponseModel findOrgByUserId(@ApiParam(name="userId", value="\u7528\u6237id\u4fe1\u606f") @RequestParam(value="userId") String userId) {
        try {
            Set org = this.organizationService.findOrgByUserId(userId);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/findByIds"})
    public ResponseModel findByIds(@RequestParam(value="id\u5217\u8868") List<String> ids) {
        try {
            Set organizationVos = this.organizationService.findByIds(ids);
            return this.buildHttpResultW(organizationVos, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784-\u6811\u7ed3\u6784\u67e5\u8be2-\u6839\u636e\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784ID\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public ResponseModel findById(@RequestParam(value="id") @ApiParam(name="id", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784Id") String id) {
        try {
            OrganizationVo result = this.organizationService.findById(id);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784-\u6811\u7ed3\u6784\u67e5\u8be2-\u6839\u636e\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784ids\u6216\u8005\u7f16\u7801\u96c6\u5408(\u5fc5\u4f20\u4efb\u4e00)\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @GetMapping(value={"/findChildrenByIdsOrCodes"})
    public ResponseModel findChildrenByIdsOrCodes(@RequestParam(value="ids", required=false) @ApiParam(name="ids", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784Ids") String[] ids, @RequestParam(value="codes", required=false) @ApiParam(name="codes", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u96c6\u5408") String[] codes) {
        try {
            List result = this.organizationService.findChildrenByIdsOrCodes(ids, codes);
            return this.buildHttpResultW(result, new String[]{"child"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784-\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u5b9e\u73b0\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/findByOrgNameLike"})
    public ResponseModel findByOrgNameLike(@RequestParam(name="orgName") @ApiParam(name="orgName", value="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0") String orgName) {
        try {
            Set organization = this.organizationService.findByOrgNameLike(orgName);
            return this.buildHttpResultW(organization, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"findByCode"})
    public ResponseModel findByCode(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801") String code) {
        try {
            OrganizationVo org = this.organizationService.findByCode(code);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7528\u6237\u6240\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f(\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)\uff0c\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f")
    @GetMapping(value={"/findByUserId"})
    public ResponseModel findByUserId(@RequestParam(name="userId") @ApiParam(value="\u7528\u6237id") String userId) {
        try {
            JSONArray org = this.organizationService.findByUserId(userId);
            return this.buildHttpResultW((Iterable)org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"findByChild"})
    public ResponseModel findByChild(@RequestParam(name="childId") String childId) {
        try {
            OrganizationVo org = this.organizationService.findByChild(childId);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u7684\u4e3b\u7ec4\u7ec7\u673a\u6784")
    @PatchMapping(value={"updateUserMainOrg"})
    public ResponseModel updateUserMainOrg(@RequestParam @ApiParam(value="\u7528\u6237ID") String userId, @RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") String orgId) {
        try {
            this.organizationService.updateUserMainOrg(userId, orgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u767b\u9646\u4eba\u5173\u8054\u7684\u7ec4\u7ec7\u67e5\u8be2\u63a7\u4ef6")
    @GetMapping(value={"findByPrincipal"})
    public ResponseModel findByPrincipal(@RequestParam @ApiParam(value="\u7c7b\u578b, 1:\u5173\u8054\u7ec4\u7ec7\u4e0a\u7ea7, 2\uff1a\u5173\u8054\u7ec4\u7ec7\u4e0b\u7ea7, 3\uff1a\u5173\u8054\u7ec4\u7ec7\u4e0a\u4e0b\u7ea7, 4\uff1a\u5173\u8054\u7ec4\u7ec7") Integer type) {
        try {
            Principal principal = this.getPrincipal();
            Set orgs = this.organizationService.findByPrincipal(type, principal);
            return this.buildHttpResult(orgs);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u767b\u9646\u4eba\u5173\u8054\u7684\u7ec4\u7ec7\u548c\u8f93\u5165\u5c42\u7ea7\u67e5\u8be2\u63a7\u4ef6")
    @GetMapping(value={"findByTypeAndLevel"})
    public ResponseModel findByTypeAndLevel(@RequestParam(required=true) @ApiParam(value="\u7c7b\u578b, 1:\u7ec4\u7ec7\u4e0a\u7ea7, 2\uff1a\u7ec4\u7ec7\u4e0b\u7ea7") Integer type, @RequestParam(required=true) @ApiParam(value="\u5c42\u7ea7") Integer level) {
        try {
            Principal principal = this.getPrincipal();
            String account = principal.getName();
            Set orgs = this.organizationService.findByTypeAndLevel(type, account, level);
            return this.buildHttpResult(orgs);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u4e2d\u9009\u62e9\u53e6\u4e00\u4e2a\u7ec4\u7ec7\u8282\u70b9\uff0c\u628a\u5217\u8868\u4e2d\u9009\u4e2d\u7ec4\u7ec7\u5408\u5e76\u5230\u7ec4\u7ec7\u6811\u4e2d\u9009\u62e9\u7684\u7ec4\u7ec7")
    @PatchMapping(value={"/mergeOrgById"})
    public ResponseModel mergeOrgById(@RequestParam(name="id") @ApiParam(name="id", value="\u5f53\u524d\u7684\u88ab\u5408\u5e76\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String id, @RequestParam(name="currentOrgId", required=false) @ApiParam(name="currentOrgId", value="\u6307\u5b9a\u53bb\u66ff\u6362\u88ab\u5408\u5e76\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId) {
        try {
            this.organizationService.mergeOrgById(id, currentOrgId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByIdStruSelfAndDescendant"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u5f53\u524d\u7ec4\u7ec7\u7684\u6240\u6709\u4e0b\u7ea7")
    public ResponseModel findByIdStruSelfAndDescendant(@RequestParam(required=false) @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID\uff0c\u4e0d\u4f20\u5219\u8fd4\u56de\u6240\u6709\u7ec4\u7ec7\u673a\u6784") String id) {
        try {
            List orgs = this.organizationService.findByIdStruSelfAndDescendant(id);
            return this.buildHttpResultW(orgs, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByLevel"})
    @ApiOperation(value="\u6839\u636e\u5c42\u7ea7\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784")
    public ResponseModel findByLevel(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u5c42\u7ea7") Integer level) {
        try {
            List orgs = this.organizationService.findByLevel(level);
            return this.buildHttpResultW(orgs, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findParentsByLevel"})
    @ApiOperation(value="\u6839\u636e\u5c42\u7ea7\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784")
    public ResponseModel findParentsByLevel(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u5c42\u7ea7") Integer level) {
        try {
            List orgs = this.organizationService.findParentsByLevel(level);
            return this.buildHttpResultW(orgs, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

