/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/positionLevels"})
public class PositionLevelController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionLevelController.class);
    @Autowired
    private PositionLevelService positionLevelService;

    @PostMapping(value={""})
    @ApiOperation(value="\u6dfb\u52a0\u804c\u4f4d\u7ea7\u522b")
    public ResponseModel create(@ApiParam(name="\u804c\u4f4d\u7ea7\u522b\u76f8\u5173\u4fe1\u606f") @RequestBody PositionLevelVo positionLevel) {
        try {
            PositionLevelVo positionLevelVo = this.positionLevelService.create(positionLevel);
            return this.buildHttpResultW(positionLevelVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u4fee\u6539\u804c\u4f4d\u7ea7\u522b")
    public ResponseModel update(@ApiParam(name="\u804c\u4f4d\u7ea7\u522b\u76f8\u5173\u4fe1\u606f") @RequestBody PositionLevelVo positionLevel) {
        try {
            PositionLevelVo positionLevelVo = this.positionLevelService.update(positionLevel);
            return this.buildHttpResultW(positionLevelVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"disableByIds"})
    @ApiOperation(value="\u7981\u7528\u4e00\u4e2a\u6216\u591a\u4e2a\u804c\u4f4d\u7ea7\u522b\u72b6\u6001")
    public ResponseModel disableByIds(@RequestParam @ApiParam(value="\u6307\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u804c\u4f4d\u7ea7\u522bID") String[] ids) {
        try {
            this.positionLevelService.disableByIds(ids);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"enableByIds"})
    @ApiOperation(value="\u542f\u7528\u4e00\u4e2a\u6216\u591a\u4e2a\u804c\u4f4d\u7ea7\u522b\u72b6\u6001")
    public ResponseModel enableByIds(@RequestParam @ApiParam(value="\u6307\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u804c\u4f4d\u7ea7\u522bID") String[] positionLevelIds) {
        try {
            this.positionLevelService.enableByIds(positionLevelIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u804c\u4f4d\u7ea7\u522b\uff0c\u540d\u79f0\u53ef\u6a21\u7cca\u67e5\u8be2\uff0c\u7f16\u7801\u4e3a\u7cbe\u786e\u67e5\u8be2")
    public ResponseModel findByConditions(@ApiParam(value="\u540d\u79f0") @RequestParam(required=false) String name, @ApiParam(value="\u7f16\u7801") @RequestParam(required=false) String code, @PageableDefault(value=50) Pageable pageable) {
        try {
            HashMap<String, String> conditions = new HashMap<String, String>();
            conditions.put("code", code);
            conditions.put("name", name);
            InvokeParams invokeParams = new InvokeParams();
            invokeParams.putInvokeParams(conditions);
            Page page = this.positionLevelService.findByConditions(invokeParams, pageable);
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6309\u7167ID\u67e5\u8be2\u804c\u4f4d\u7ea7\u522b")
    public ResponseModel findById(@PathVariable(value="id") String id) {
        try {
            PositionLevelVo positionLevelVo = this.positionLevelService.findById(id);
            return this.buildHttpResultW(positionLevelVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findByCode"})
    @ApiOperation(value="\u6309\u7167\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u7ea7\u522b")
    public ResponseModel findByCode(@ApiParam(value="\u7f16\u7801") @RequestParam(value="code") String code) {
        try {
            PositionLevelVo positionLevelVo = this.positionLevelService.findByCode(code);
            return this.buildHttpResultW(positionLevelVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"/deleteByIds"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\u804c\u4f4d\u7ea7\u522b")
    public ResponseModel deleteByIds(@ApiParam(value="\u804c\u4f4d\u7ea7\u522bID\u6570\u7ec4") @RequestParam String[] ids) {
        try {
            this.positionLevelService.deleteByIds(ids);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u804c\u7ea7\uff08\u672a\u5220\u9664\u7684\uff09")
    @GetMapping(value={"/findAll"})
    public ResponseModel findAll() {
        try {
            List result = this.positionLevelService.findAll();
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

