package com.bizunited.platform.user.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.service.UserExtentFieldService;
import com.bizunited.platform.user.common.vo.UserExtentFieldVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户扩展字段的Controller
 * @Author: zengxingwang
 * @Date: 2020/4/3 11:23
 */
@RestController
@RequestMapping("/v1/nebula/field")
public class UserExtentFieldController extends BaseController {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(UserExtentFieldController.class);

  @Autowired
  private UserExtentFieldService userExtentFieldService;

  /**
   * 配置附加字段
   * @param userExtentFieldVos
   * @return
   */
  @ApiOperation("配置附加字段")
  @PostMapping
  public ResponseModel save(
          @ApiParam(name = "userExtentFieldVos", value = "附加字段信息", required = true) @RequestBody List<UserExtentFieldVo> userExtentFieldVos) {
    try {
      List<UserExtentFieldVo> userExtentFields = this.userExtentFieldService.save(userExtentFieldVos);
      return this.buildHttpResult(userExtentFields);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 查询所有的配置
   * @return
   */
  @ApiOperation("查询所有的配置")
  @GetMapping("/findAll")
  public ResponseModel findAll() {
    try {
      List<UserExtentFieldVo> userExtentFields = this.userExtentFieldService.findAll();
      return this.buildHttpResult(userExtentFields);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
