/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/position"})
public class PositionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionController.class);
    @Autowired
    private PositionService positionService;

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u7528\u6237\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2", notes="<strong>\u5b57\u6bb5\u63cf\u8ff0</strong><br>code:\u804c\u4f4d\u7f16\u7801\uff0c\u7528\u4e8e\u7b49\u4e8e\u5339\u914d<br>nameEqual:\u804c\u4f4d\u540d\u79f0\uff0c\u7528\u4e8e\u7b49\u4e8e\u5339\u914d<br>tstatus:\u804c\u4f4d\u72b6\u6001\uff0c\u7528\u4e8e\u7b49\u4e8e\u5339\u914d<br>flag:\u7f16\u7801\u3001id\u662f\u5426\u67e5\u8be2\u96c6\u5408\u8303\u56f4\u5185\u7684\u6807\u8bb0\uff0c\u4e3a1\u67e5\u8be2\u96c6\u5408\u8303\u56f4\u5185\uff0c\u4e3a0\u67e5\u8be2\u96c6\u5408\u8303\u56f4\u5916<br>ids:id\u96c6\u5408<br>codes:\u7f16\u7801\u96c6\u5408<br>name:\u804c\u4f4d\u540d\u79f0\uff0c\u7528\u6237\u6a21\u7cca\u5339\u914d<br>userName:\u7528\u6237\u540d\uff0c\u7528\u4e8e\u6a21\u7cca\u5339\u914d<br>positionLevel:\u804c\u7ea7id<br>orgName:\u7ec4\u7ec7\u540d\u79f0\uff0c\u7528\u4e8e\u6a21\u7cca\u5339\u914d")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u6ce8\uff1a\u5982\u679c\u8981\u7528\u2018==\u2018\u5339\u914d\u804c\u4f4d\u540d\u79f0\uff0c\u4f20nameEqual", example="{\n    \"code\": \"\",\n    \"nameEqual\": \"\",\n    \"tstatus\": \"\",\n    \"flag\": \"\",\n    \"ids\": [],\n    \"codes\": [],\n    \"name\": \"\",\n    \"userName\": \"\",\n    \"positionLevel\": ,\n    \"orgName\": \"\"\n  }") @RequestParam Map<String, Object> conditions, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page page = this.positionService.findByConditions(conditions, pageable);
            return this.buildHttpResultW(page, new String[]{"organization", "parent", "positionLevel"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5c97\u4f4d\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u5305\u62ec\u76f8\u5173\u7ec4\u7ec7\u3001\u89d2\u8272\u3001\u7528\u6237\u7b49")
    @GetMapping(value={"/find/{positionId}"})
    public ResponseModel findDetailsById(@PathVariable(value="positionId") String positionId) {
        try {
            PositionVo positionVo = this.positionService.findDetailsById(positionId);
            return this.buildHttpResultW(positionVo, new String[]{"organization", "roles", "parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6dfb\u52a0\u5c97\u4f4d")
    @PostMapping
    public ResponseModel create(@ApiParam(value="\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f") @RequestBody PositionVo position) {
        try {
            PositionVo positionVo = this.positionService.create(position);
            return this.buildHttpResultW(positionVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5c97\u4f4d")
    @PatchMapping(value={"update"})
    public ResponseModel update(@ApiParam(value="\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f") @RequestBody PositionVo position) {
        try {
            PositionVo positionVo = this.positionService.update(position);
            return this.buildHttpResultW(positionVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5c97\u4f4d\u72b6\u6001\uff08\u542f\u7528\u7981\u7528\uff09")
    @PatchMapping(value={"updateStatus/{positionId}"})
    public ResponseModel updateStatus(@PathVariable(value="positionId") String positionId) {
        try {
            PositionVo positionVo = this.positionService.updateStatus(positionId);
            return this.buildHttpResultW(positionVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ed1\u5b9a\u6307\u5b9a\u7684\u5c97\u4f4d\u548c\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784")
    @PatchMapping(value={"/bindOrg"})
    public ResponseModel bindOrg(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="orgId") @ApiParam(name="orgId", value="\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\uff08orgId\uff09") String orgId) {
        try {
            this.positionService.bindOrg(orgId, positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u6307\u5b9a\u7684\u5c97\u4f4d\u548c\u4efb\u4f55\u7ec4\u7ec7\u673a\u6784\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindOrg"})
    public ResponseModel unbindOrg(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId) {
        try {
            this.positionService.unbindOrg(positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5728\u5ffd\u7565\u6307\u5b9a\u5c97\u4f4d\u662f\u5426\u5df2\u7ecf\u7ed1\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u524d\u63d0\u4e0b\uff0c\u91cd\u65b0\u4e3a\u8fd9\u4e2a\u6307\u5b9a\u7684\u5c97\u4f4d\u7ed1\u5b9a\u65b0\u7684\u7ec4\u7ec7\u673a\u6784")
    @PatchMapping(value={"/reBindOrg"})
    public ResponseModel reBindOrg(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="orgId") @ApiParam(name="orgId", value="\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\uff08orgId\uff09") String orgId) {
        try {
            this.positionService.reBindOrg(orgId, positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u4e00\u4e2a\u5c97\u4f4d\u548c\u6307\u5b9a\u7684\u591a\u4e2a\u7528\u6237\u5f62\u6210\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/bindUsersAndPosition"})
    public ResponseModel bindUsers(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u5f53\u524d\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="userIds") @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.positionService.bindUsersAndPosition(Arrays.asList(userIds), positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u591a\u4e2a\u7528\u6237\u4e0e\u67d0\u4e00\u6307\u5b9a\u7684\u5c97\u4f4d")
    @PatchMapping(value={"/unbindUsersAndPosition"})
    public ResponseModel unbindUsersAndPosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u6307\u5b9a\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="userIds") @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u7528\u6237ID") String[] userIds) {
        try {
            this.positionService.unbindUsersAndPosition(Arrays.asList(userIds), positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u67e5\u8be2\u7528\u6237\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/findByUserId"})
    public ResponseModel findByUserId(@ApiParam(name="userId", value="\u7528\u6237id") @RequestParam(value="userId") String userId) {
        try {
            List position = this.positionService.findByUserId(userId);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u67e5\u8be2\u7528\u6237\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/findByUserAccount"})
    public ResponseModel findByUserAccount(@ApiParam(name="userAccount", value="\u7528\u6237\u8d26\u53f7") @RequestParam(value="userAccount") String userAccount) {
        try {
            List position = this.positionService.findByUserAccount(userAccount);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u7528\u6237\u5c97\u4f4d\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/findByIds"})
    public ResponseModel findByIds(@RequestParam(value="id\u6570\u7ec4", defaultValue="[]") @ApiParam(value="id\u6570\u7ec4") String[] ids) {
        try {
            Set position = this.positionService.findByIds(Arrays.asList(ids));
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5c97\u4f4d\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"findByCode"})
    public ResponseModel findByCode(@RequestParam @ApiParam(value="\u5c97\u4f4d\u7f16\u7801") String code) {
        try {
            PositionVo position = this.positionService.findByCode(code);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5207\u6362\u5c97\u4f4d")
    @PostMapping(value={"changePosition"})
    public ResponseModel changePosition(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u5c97\u4f4did", required=true) String positionId, @RequestParam(name="userId") @ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237ID", required=true) String userId) {
        try {
            UserVo userVo = this.positionService.changePosition(positionId, userId);
            return this.buildHttpResultW(userVo, new String[]{"roles", "positions"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4e3b\u5c97\u4f4d")
    @GetMapping(value={"findMainPositionByUserId"})
    public ResponseModel findMainPositionByUserId(@RequestParam @ApiParam(value="\u7528\u6237id") String userId) {
        try {
            PositionVo position = this.positionService.findMainPositionByUserId(userId);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u4e00\u4e2a\u5c97\u4f4d\u548c\u6307\u5b9a\u7684\u591a\u4e2a\u7528\u6237\u91cd\u65b0\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/rebindUsers"})
    public ResponseModel rebindUsers(@RequestParam(name="positionId") @ApiParam(name="positionId", value="\u5f53\u524d\u7684\u5c97\u4f4dID") String positionId, @RequestParam(name="userIds", required=false) @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.positionService.rebindUsers(userIds, positionId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5c97\u4f4d\u4fe1\u606f\uff08\u6839\u636e\u521b\u5efa\u65f6\u95f4\u6392\u5e8f\uff09")
    @GetMapping(value={"/findAll"})
    public ResponseModel findAll() {
        try {
            List positions = this.positionService.findAll();
            return this.buildHttpResultW(positions, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u72b6\u6001\u67e5\u8be2\u5c97\u4f4d")
    @GetMapping(value={"findByStatus"})
    public ResponseModel findByStatus(@RequestParam(required=false) @ApiParam(value="\u72b6\u6001") Integer status) {
        try {
            List positions = this.positionService.findByStatus(status);
            return this.buildHttpResultW(positions, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u767b\u9646\u4eba\u5173\u8054\u7684\u5c97\u4f4d\u67e5\u8be2\u63a7\u4ef6")
    @GetMapping(value={"findByPrincipal"})
    public ResponseModel findByPrincipal(@RequestParam(required=true) @ApiParam(value="\u7c7b\u578b, 1:\u5173\u8054\u5c97\u4f4d\u4e0a\u7ea7, 2\uff1a\u5173\u8054\u5c97\u4f4d\u4e0b\u7ea7, 3\uff1a\u5173\u8054\u5c97\u4f4d\u4e0a\u4e0b\u7ea7, 4\uff1a\u5173\u8054\u5c97\u4f4d") Integer type) {
        try {
            Principal principal = this.getPrincipal();
            Set positions = this.positionService.findByPrincipal(type, principal);
            return this.buildHttpResult(positions);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u767b\u9646\u4eba\u5173\u8054\u7684\u5c97\u4f4d\u548c\u8f93\u5165\u5c42\u7ea7\u67e5\u8be2\u63a7\u4ef6")
    @GetMapping(value={"findByTypeAndLevel"})
    public ResponseModel findByTypeAndLevel(@RequestParam(required=true) @ApiParam(value="\u7c7b\u578b, 1:\u5c97\u4f4d\u4e0a\u7ea7, 2\uff1a\u5c97\u4f4d\u4e0b\u7ea7") Integer type, @RequestParam(required=true) @ApiParam(value="\u5c42\u7ea7") Integer level) {
        try {
            Principal principal = this.getPrincipal();
            Set positions = this.positionService.findByTypeAndLevel(type, principal, level);
            return this.buildHttpResult(positions);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u7ea7\u521b\u5efa\u76f8\u5173\u804c\u4f4d")
    @PostMapping(value={"createByPositionLevelCode"})
    public ResponseModel createByPositionLevelCode(@RequestParam @ApiParam(value="\u5c42\u7ea7\u7f16\u7801") String levelCode) {
        try {
            PositionVo position = this.positionService.createByPositionLevelCode(levelCode);
            return this.buildHttpResultW(position, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u76f8\u5173\u4fe1\u606f\uff08\u5305\u62ec\u7ec4\u7ec7\uff0c\u804c\u7ea7\uff0c\u7528\u6237\uff09")
    @GetMapping(value={"findDetailsByOrgCode"})
    public ResponseModel findDetailsByOrgCode(@RequestParam(required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801") String orgCode) {
        try {
            List positions = this.positionService.findDetailsByOrgCode(orgCode);
            return this.buildHttpResultW(positions, new String[]{"positionLevel", "users", "organization", "children"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u7684\u6240\u6709\u4e0b\u7ea7\u4fe1\u606f")
    @GetMapping(value={"findDetailsByCode"})
    public ResponseModel findDetailsByCode(@RequestParam @ApiParam(value="\u7f16\u7801") String code) {
        try {
            List positions = this.positionService.findDetailsByCode(code);
            return this.buildHttpResultW(positions, new String[]{"positionLevel", "users", "organization"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u7684\u6240\u6709\u4e0b\u7ea7\u4fe1\u606f", notes="<strong>\u53c2\u6570\u8bf4\u660e\uff1a</strong>name: \u804c\u4f4d\u540d\u79f0\norgName: \u7ec4\u7ec7\u540d\u79f0\nuserName: \u7528\u6237\u540d\u79f0\npositionLevel: \u804c\u7ea7id\npage: \u9875\u7801\nsize: \u6bcf\u9875\u67e5\u8be2\u6570\u91cf")
    @GetMapping(value={"findByPositionLevelAndConditions"})
    public ResponseModel findByPositionLevelAndConditions(@ApiParam(value="\u53c2\u6570") Map<String, Object> conditions, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u4fe1\u606f") Pageable pageable) {
        try {
            Page result = this.positionService.findByPositionLevelAndConditions(pageable, conditions);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4dId\u6279\u91cf\u7981\u7528\u804c\u4f4d")
    @PatchMapping(value={"disableByIds"})
    public ResponseModel disableByIds(@RequestParam @ApiParam(value="id\u6570\u7ec4") String[] ids) {
        try {
            this.positionService.disableByIds(ids);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4dId\u6279\u91cf\u542f\u7528\u804c\u4f4d")
    @PatchMapping(value={"enableByIds"})
    public ResponseModel enableByIds(@RequestParam @ApiParam(value="id\u6570\u7ec4") String[] ids) {
        try {
            this.positionService.enableByIds(ids);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4dId\u6279\u91cf\u542f\u7528\u804c\u4f4d")
    @PatchMapping(value={"/reBindOrgCode"})
    public ResponseModel reBindOrgCode(@RequestParam(value="codes") @ApiParam(value="\u804c\u4f4d\u7f16\u7801") String[] codes, @RequestParam(value="orgCode") @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801") String orgCode) {
        try {
            this.positionService.reBindOrgCode(codes, orgCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u67e5\u8be2\u6240\u6709\u4e0b\u7ea7\u804c\u4f4d")
    @GetMapping(value={"/findByUserIdStrDescendant"})
    public ResponseModel findByUserIdStrDescendant(@RequestParam @ApiParam(value="\u7528\u6237id") String userId) {
        try {
            List result = this.positionService.findByUserIdStruDescendant(userId);
            return this.buildHttpResultW(result, new String[]{"users"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ed1\u5b9a\u7236\u7ea7\u804c\u4f4d")
    @PatchMapping(value={"bindParent"})
    public ResponseModel bindParent(@ApiParam(value="\u5f53\u524d\u804c\u4f4did") @RequestParam String id, @ApiParam(value="\u7236\u7ea7\u804c\u4f4did") @RequestParam String parentId) {
        try {
            PositionVo positionVo = this.positionService.bindParent(id, parentId);
            return this.buildHttpResult(positionVo);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

