/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.user.common.service.region.AdministrativeRegionService;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import com.bizunited.platform.user.excel.transfer.AdministrativeRegionExportVoTransfer;
import com.bizunited.platform.user.excel.vo.AdministrativeRegionExportVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="AdministrativeRegionExportProcess")
public class AdministrativeRegionExportProcess
implements FormDetailsExportBoxProcess<AdministrativeRegionExportVo> {
    @Autowired
    private AdministrativeRegionService administrativeRegionService;

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public Page<AdministrativeRegionExportVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params) {
        JSONArray jsonArray = exportParam.orElse(new JSONArray());
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            String code = jsonObject.getString("code");
            Object value = jsonObject.get((Object)"value");
            conditions.put(code, value);
        }
        List<AdministrativeRegionVo> regions = this.administrativeRegionService.findByConditions(conditions);
        if (CollectionUtils.isEmpty((Collection)regions)) {
            return Page.empty((Pageable)pageable);
        }
        regions = this.tree2List(null, regions);
        Collection collection = CollectionTransferUtils.transfer(regions, (Transfer)new AdministrativeRegionExportVoTransfer(), HashSet.class, ArrayList.class);
        return new PageImpl((List)Lists.newArrayList((Iterable)collection), pageable, (long)pageable.getPageSize());
    }

    private List<AdministrativeRegionVo> tree2List(AdministrativeRegionVo parent, List<AdministrativeRegionVo> regions) {
        if (CollectionUtils.isEmpty(regions)) {
            return Lists.newArrayList();
        }
        ArrayList<AdministrativeRegionVo> list = new ArrayList<AdministrativeRegionVo>();
        for (AdministrativeRegionVo region : regions) {
            region.setParent(parent);
            list.add(region);
            list.addAll(this.tree2List(region, region.getChildren()));
        }
        return list;
    }
}

