/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.excel.process;

import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.user.common.service.region.AdministrativeRegionService;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import com.bizunited.platform.user.excel.vo.AdministrativeRegionImportVo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="AdministrativeRegionImportProcess")
public class AdministrativeRegionImportProcess
implements FormDetailsImportBoxProcess<AdministrativeRegionVo, AdministrativeRegionImportVo> {
    @Autowired
    private AdministrativeRegionService administrativeRegionService;
    private Map<String, AdministrativeRegionImportVo> importMap = new HashMap<String, AdministrativeRegionImportVo>();
    private Map<String, AdministrativeRegionVo> dbRegionMap = new HashMap<String, AdministrativeRegionVo>();

    public AdministrativeRegionVo process(AdministrativeRegionImportVo excelBean, Map<String, Object> params, String templateCode, String templateVersion) {
        try {
            this.validate(excelBean);
        }
        catch (RuntimeException e) {
            throw new ExcelMigrateException(e.getMessage(), (Throwable)e);
        }
        AdministrativeRegionVo region = new AdministrativeRegionVo();
        region.setRegionName(excelBean.getRegionName());
        region.setRegionCode(excelBean.getRegionCode());
        region.setLongitude(excelBean.getLongitude());
        region.setLatitude(excelBean.getLatitude());
        region.setEmail(excelBean.getEmail());
        String parentCode = excelBean.getParentCode();
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            AdministrativeRegionVo parent = new AdministrativeRegionVo();
            parent.setRegionCode(parentCode);
            region.setParent(parent);
        }
        return region;
    }

    public void execute(AdministrativeRegionVo region, Map<String, Object> params) {
        AdministrativeRegionVo parent = region.getParent();
        if (parent != null) {
            AdministrativeRegionVo dbParent = this.dbRegionMap.get(parent.getRegionCode());
            region.setParent(dbParent);
        }
        AdministrativeRegionVo dbRegion = this.administrativeRegionService.create(region);
        this.dbRegionMap.put(dbRegion.getRegionCode(), dbRegion);
    }

    private void validate(AdministrativeRegionImportVo excelBean) {
        AdministrativeRegionImportVo parent;
        Validate.notNull((Object)excelBean, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)excelBean.getRegionCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)excelBean.getRegionName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)excelBean.getLongitude(), (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)excelBean.getLatitude(), (String)"\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!this.importMap.containsKey(excelBean.getRegionCode()) ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u884c\u653f\u533a\u57df\uff1a%s", (Object[])new Object[]{excelBean.getRegionCode()});
        String parentCode = excelBean.getParentCode();
        if (StringUtils.isNotBlank((CharSequence)parentCode) && (parent = this.importMap.get(parentCode)) == null) {
            AdministrativeRegionVo dbParent = this.administrativeRegionService.findByCode(parentCode);
            Validate.notNull((Object)dbParent, (String)"\u672a\u627e\u5230\u884c\u653f\u533a\u57df\u3010%s\u3011\u7684\u4e0a\u7ea7\u533a\u57df\uff1a%s\uff0c\u8bf7\u68c0\u67e5\u4e0a\u7ea7\u533a\u57df\u5728\u6570\u636e\u5e93\u4e2d\u6216\u5728\u5f53\u524d\u7ec4\u7ec7\u8868\u683c\u7684\u524d\u7f6e\u884c\u4e2d", (Object[])new Object[]{excelBean.getRegionCode(), parentCode});
            this.dbRegionMap.put(parentCode, dbParent);
        }
        this.importMap.put(excelBean.getRegionCode(), excelBean);
    }
}

