/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.excel.transfer.OrganizationExportVoTransfer;
import com.bizunited.platform.user.excel.vo.OrganizationExportVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="OrganizationExportProcess")
public class OrganizationExportProcess
implements FormDetailsExportBoxProcess<OrganizationExportVo> {
    @Autowired
    private OrganizationService organizationService;

    public Page<OrganizationExportVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params) {
        JSONArray jsonArray = exportParam.orElse(new JSONArray());
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            String code = jsonObject.getString("code");
            Object value = jsonObject.get((Object)"value");
            conditions.put(code, value);
        }
        List orgs = this.organizationService.findByIdStruSelfAndDescendant((String)conditions.get("id"));
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return Page.empty((Pageable)pageable);
        }
        String exportClassName = params.get("exportClassName") != null ? params.get("exportClassName").toString() : null;
        Class<?> exportClass = null;
        if (StringUtils.isNotBlank((CharSequence)exportClassName)) {
            try {
                exportClass = Class.forName(exportClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("\u672a\u77e5\u7684\u7ec4\u7ec7\u5bfc\u51fa\u7c7b\u3010%s\u3011\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5!!", exportClassName));
            }
        }
        Collection collection = CollectionTransferUtils.transfer((Collection)orgs, exportClass, (Transfer)new OrganizationExportVoTransfer(), HashSet.class, ArrayList.class);
        return new PageImpl((List)Lists.newArrayList((Iterable)collection), pageable, (long)pageable.getPageSize());
    }
}

