/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.excel.process;

import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.excel.vo.OrganizationImportVo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="OrganizationImportProcess")
public class OrganizationImportProcess
implements FormDetailsImportBoxProcess<OrganizationVo, OrganizationImportVo> {
    @Autowired
    private OrganizationService organizationService;
    private Map<String, OrganizationImportVo> orgImportMap = new HashMap<String, OrganizationImportVo>(16);
    private Map<String, OrganizationVo> dbOrgsMap = new HashMap<String, OrganizationVo>(16);

    public OrganizationVo process(OrganizationImportVo excelBean, Map<String, Object> params, String templateCode, String templateVersion) {
        try {
            this.validate(excelBean);
        }
        catch (RuntimeException e) {
            throw new ExcelMigrateException(e.getMessage(), (Throwable)e);
        }
        OrganizationVo org = new OrganizationVo();
        org.setCode(excelBean.getCode());
        org.setOrgName(excelBean.getOrgName());
        org.setDescription(excelBean.getDescription());
        org.setType(excelBean.getType());
        org.setLevel(excelBean.getLevel());
        String parentCode = excelBean.getParentCode();
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            OrganizationVo parent = new OrganizationVo();
            parent.setCode(parentCode);
            org.setParent(parent);
        }
        return org;
    }

    public void execute(OrganizationVo org, Map<String, Object> params) {
        OrganizationVo parent = org.getParent();
        if (parent != null) {
            OrganizationVo dbParent = this.dbOrgsMap.get(parent.getCode());
            org.setParent(dbParent);
        }
        OrganizationVo dbOrg = this.organizationService.create(org);
        this.dbOrgsMap.put(dbOrg.getCode(), dbOrg);
    }

    private void validate(OrganizationImportVo excelBean) {
        OrganizationImportVo importParent;
        Validate.notNull((Object)excelBean, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)excelBean.getCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)excelBean.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)excelBean.getType(), (String)"\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)excelBean.getLevel(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!this.orgImportMap.containsKey(excelBean.getCode()) ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u7ec4\u7ec7\u673a\u6784\uff1a%s", (Object[])new Object[]{excelBean.getCode()});
        String parentCode = excelBean.getParentCode();
        if (StringUtils.isNotBlank((CharSequence)parentCode) && (importParent = this.orgImportMap.get(parentCode)) == null) {
            OrganizationVo dbParent = this.organizationService.findByCode(parentCode);
            Validate.notNull((Object)dbParent, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u3010%s\u3011\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff1a%s\uff0c\u8bf7\u68c0\u67e5\u4e0a\u7ea7\u7ec4\u7ec7\u5728\u6570\u636e\u5e93\u4e2d\u6216\u5728\u5f53\u524d\u7ec4\u7ec7\u8868\u683c\u7684\u524d\u7f6e\u884c\u4e2d", (Object[])new Object[]{excelBean.getCode(), parentCode});
            this.dbOrgsMap.put(parentCode, dbParent);
        }
        this.orgImportMap.put(excelBean.getCode(), excelBean);
    }
}

