/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.excel.process;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.excel.vo.PositionImportVo;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PositionImportProcess
implements FormDetailsImportBoxProcess<PositionVo, PositionImportVo> {
    @Autowired
    private PositionService positionService;
    @Autowired
    private PositionLevelService positionLevelService;

    public PositionVo process(PositionImportVo positionImportVo, Map<String, Object> params, String templateCode, String templateVersion) {
        if (positionImportVo == null) {
            return null;
        }
        this.validateTrue(StringUtils.isNotBlank((CharSequence)positionImportVo.getName()), "\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateTrue(StringUtils.isNotBlank((CharSequence)positionImportVo.getTstatus()), "\u804c\u4f4d\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        String parentCode = positionImportVo.getParentCode();
        String positionLevelCode = positionImportVo.getPositionLevelCode();
        PositionVo positionVo = new PositionVo();
        positionVo.setCode(positionImportVo.getCode());
        positionVo.setName(positionImportVo.getName());
        NormalStatusEnum normalStatusEnum = NormalStatusEnum.valueOfDesc((String)positionImportVo.getTstatus());
        if (normalStatusEnum != null) {
            positionVo.setTstatus(normalStatusEnum.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            PositionVo parent = this.positionService.findByCode(parentCode);
            positionVo.setParent(parent);
        }
        if (StringUtils.isNotBlank((CharSequence)positionLevelCode)) {
            PositionLevelVo positionLevelVo = this.positionLevelService.findByCode(positionLevelCode);
            positionVo.setPositionLevel(positionLevelVo);
        }
        return positionVo;
    }

    private void validateTrue(boolean expression, String message) {
        if (!expression) {
            throw new ExcelMigrateException(message);
        }
    }

    public void execute(PositionVo positionVo, Map<String, Object> params) {
        this.positionService.create(positionVo);
    }
}

