/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.excel.process;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.user.common.enums.UserGenderEnum;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.excel.vo.UserImportExcelVo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserImportProcess
implements FormDetailsImportBoxProcess<UserVo, UserImportExcelVo> {
    private String encodedPassword;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    @Qualifier(value="passwordEncoder")
    @Lazy
    private PasswordEncoder passwordEncoder;

    @PostConstruct
    public void init() {
        this.encodedPassword = this.passwordEncoder.encode((CharSequence)"12345678");
    }

    public UserVo process(UserImportExcelVo excelBean, Map<String, Object> params, String templateCode, String templateVersion) {
        try {
            this.validateExcelBean(excelBean);
            return this.copyExcelToEntity(excelBean);
        }
        catch (Exception e) {
            throw new ExcelMigrateException(e.getMessage());
        }
    }

    public void execute(UserVo userVo, Map<String, Object> params) {
        userVo.setPassword(this.encodedPassword);
        this.userService.create(userVo);
    }

    public String importProcessName() {
        return "\u7528\u6237\u5bfc\u5165";
    }

    private UserVo copyExcelToEntity(UserImportExcelVo excelBean) {
        this.convertGender(excelBean);
        return (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)excelBean, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void convertGender(UserImportExcelVo excelBean) {
        String gender = excelBean.getGenderStr();
        UserGenderEnum userGenderEnum = UserGenderEnum.valueOfDesc((String)gender);
        excelBean.setGender(Objects.nonNull(userGenderEnum) ? userGenderEnum.getGender() : null);
    }

    private void validateExcelBean(UserImportExcelVo excelBean) {
        String account = excelBean.getAccount();
        UserVo byAccount = this.userService.findByAccount(account);
        Validate.isTrue((boolean)Objects.isNull(byAccount), (String)"\u8d26\u53f7\uff1a%s\uff0c\u5df2\u5b58\u5728", (Object[])new Object[]{account});
        String phone = excelBean.getPhone();
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            UserVo byPhone = this.userService.findByPhone(phone);
            Validate.isTrue((boolean)Objects.isNull(byPhone), (String)"\u7535\u8bdd\uff1a%s\uff0c\u5df2\u5b58\u5728", (Object[])new Object[]{phone});
        }
    }
}

