/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.user.excel.transfer;

import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.user.common.enums.OrganizationTypeEnum;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.excel.vo.OrganizationExportVo;
import org.springframework.beans.BeanUtils;

public class OrganizationExportVoTransfer
implements Transfer<OrganizationVo, OrganizationExportVo> {
    public OrganizationExportVo transfer(OrganizationVo orgVo) {
        if (orgVo == null) {
            return null;
        }
        OrganizationExportVo exportVo = new OrganizationExportVo();
        exportVo.setCode(orgVo.getCode());
        exportVo.setOrgName(orgVo.getOrgName());
        exportVo.setDescription(orgVo.getDescription());
        OrganizationTypeEnum organizationTypeEnum = OrganizationTypeEnum.valueOfType((Integer)orgVo.getType());
        if (organizationTypeEnum != null) {
            exportVo.setTypeName(organizationTypeEnum.getDesc());
        }
        exportVo.setLevel(orgVo.getLevel());
        OrganizationVo parent = orgVo.getParent();
        if (orgVo.getParent() != null) {
            exportVo.setParentCode(parent.getCode());
            exportVo.setParentName(parent.getOrgName());
        }
        return exportVo;
    }

    public OrganizationExportVo transfer(OrganizationVo orgVo, Class<? extends OrganizationExportVo> specifyClass) {
        if (orgVo == null || specifyClass == null) {
            return null;
        }
        OrganizationExportVo exportVo = null;
        try {
            exportVo = specifyClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("\u7ec4\u7ec7\u673a\u6784\u5bfc\u51fa\u7c7b\u8f6c\u6362\u503c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        BeanUtils.copyProperties((Object)orgVo, (Object)exportVo);
        OrganizationTypeEnum organizationTypeEnum = OrganizationTypeEnum.valueOfType((Integer)orgVo.getType());
        if (organizationTypeEnum != null) {
            exportVo.setTypeName(organizationTypeEnum.getDesc());
        }
        OrganizationVo parent = orgVo.getParent();
        if (orgVo.getParent() != null) {
            exportVo.setParentCode(parent.getCode());
            exportVo.setParentName(parent.getOrgName());
        }
        return exportVo;
    }
}

