package com.bizunited.platform.user.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.user.common.service.region.AdministrativeRegionService;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import com.bizunited.platform.user.excel.transfer.AdministrativeRegionExportVoTransfer;
import com.bizunited.platform.user.excel.vo.AdministrativeRegionExportVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static javax.transaction.Transactional.TxType.NOT_SUPPORTED;

/**
 * 行政区域导出服务
 * @Author: Paul Chan
 * @Date: 2020/11/2 21:32
 */
@Component("AdministrativeRegionExportProcess")
public class AdministrativeRegionExportProcess implements FormDetailsExportBoxProcess<AdministrativeRegionExportVo> {

  @Autowired
  private AdministrativeRegionService administrativeRegionService;

  @Override
  @Transactional(NOT_SUPPORTED)
  public Page<AdministrativeRegionExportVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params) {
    JSONArray jsonArray = exportParam.orElse(new JSONArray());
    Map<String, Object> conditions = new HashMap<>();
    for (Object o : jsonArray) {
      JSONObject jsonObject = (JSONObject) o;
      String code = jsonObject.getString("code");
      Object value = jsonObject.get("value");
      conditions.put(code, value);
    }
    List<AdministrativeRegionVo> regions = administrativeRegionService.findByConditions(conditions);
    if(CollectionUtils.isEmpty(regions)) {
      return Page.empty(pageable);
    }
    regions = this.tree2List(null, regions);
    Collection<AdministrativeRegionExportVo> collection = CollectionTransferUtils.transfer(regions, new AdministrativeRegionExportVoTransfer(), HashSet.class, ArrayList.class);
    return new PageImpl<>(Lists.newArrayList(collection), pageable, pageable.getPageSize());
  }

  /**
   * 将树结构转换为list
   * @param regions
   * @return
   */
  private List<AdministrativeRegionVo> tree2List(AdministrativeRegionVo parent, List<AdministrativeRegionVo> regions) {
    if(CollectionUtils.isEmpty(regions)) {
      return Lists.newArrayList();
    }
    List<AdministrativeRegionVo> list = new ArrayList<>();
    for (AdministrativeRegionVo region : regions) {
      region.setParent(parent);
      list.add(region);
      list.addAll(this.tree2List(region, region.getChildren()));
    }
    return list;
  }

}
