package com.bizunited.platform.user.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.excel.transfer.OrganizationExportVoTransfer;
import com.bizunited.platform.user.excel.vo.OrganizationExportVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 组织机构导出实现过程
 * @Author: Paul Chan
 * @Date: 2020/10/28 10:32
 */
@Component("OrganizationExportProcess")
public class OrganizationExportProcess implements FormDetailsExportBoxProcess<OrganizationExportVo> {

  @Autowired
  private OrganizationService organizationService;

  @SuppressWarnings("unchecked")
  @Override
  public Page<OrganizationExportVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params) {
    JSONArray jsonArray = exportParam.orElse(new JSONArray());
    Map<String, Object> conditions = new HashMap<>();
    for (Object o : jsonArray) {
      JSONObject jsonObject = (JSONObject) o;
      String code = jsonObject.getString("code");
      Object value = jsonObject.get("value");
      conditions.put(code, value);
    }
    List<OrganizationVo> orgs = organizationService.findByIdStruSelfAndDescendant((String) conditions.get("id"));
    if(CollectionUtils.isEmpty(orgs)) {
      return Page.empty(pageable);
    }
    String exportClassName = params.get("exportClassName") != null ? params.get("exportClassName").toString() : null;
    Class<? extends OrganizationExportVo> exportClass = null;
    if(StringUtils.isNotBlank(exportClassName)){
      try {
        exportClass = (Class<? extends OrganizationExportVo>) Class.forName(exportClassName);
      } catch (ClassNotFoundException e) {
        throw new IllegalArgumentException(String.format("未知的组织导出类【%s】设置，请检查!!",exportClassName));
      }
    }
    Collection<OrganizationExportVo> collection = CollectionTransferUtils.transfer(orgs, exportClass,new OrganizationExportVoTransfer(), HashSet.class, ArrayList.class);
    return new PageImpl<>(Lists.newArrayList(collection), pageable, pageable.getPageSize());
  }

}
