package com.bizunited.platform.user.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.excel.transfer.PositionExportTransfer;
import com.bizunited.platform.user.excel.vo.PositionExportVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 角色导入/导出实现类
 * @Author: chenrong
 * @Date: 2020/10/26 15:38
 */
@Component
public class PositionExportProcess implements FormDetailsExportBoxProcess<PositionExportVo> {

  @Autowired
  private PositionService positionService;
  @Autowired
  private PositionExportTransfer positionExportTransfer;

  /**
   * 导出实现方法
   * @param pageable
   * @param dataViewCode
   * @param exportFiled
   * @param exportParam
   * @param params
   * @return
   */
  @Override
  public Page<PositionExportVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params){
    Page<PositionVo> page = this.positionService.findByConditions(Maps.newHashMap(), pageable);
    if(page == null || CollectionUtils.isEmpty(page.getContent())){
      return Page.empty(pageable);
    }
    Collection<PositionExportVo> collection = CollectionTransferUtils.transfer(page.getContent(), positionExportTransfer, HashSet.class, ArrayList.class);
    List<PositionExportVo> positionExportVos = Lists.newArrayList(collection);
    return new PageImpl<>(positionExportVos, pageable, page.getTotalElements());
  }
}
