package com.bizunited.platform.user.excel.process;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import java.util.Map;

import com.bizunited.platform.user.excel.vo.PositionImportVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 职位导入对象模型
 * @Author: chenrong
 * @Date: 2020/10/28 11:36
 */
@Component
public class PositionImportProcess implements FormDetailsImportBoxProcess<PositionVo, PositionImportVo> {

  @Autowired
  private PositionService positionService;
  @Autowired
  private PositionLevelService positionLevelService;

  /**
   * 导入实现方法
   * @param positionImportVo
   * @param params
   * @param templateCode
   * @param templateVersion
   * @return
   */
  @Override
  public PositionVo process(PositionImportVo positionImportVo, Map<String, Object> params, String templateCode, String templateVersion){
    if(positionImportVo == null){
      return null;
    }
    this.validateTrue(StringUtils.isNotBlank(positionImportVo.getName()), "职位名称不能为空");
    this.validateTrue(StringUtils.isNotBlank(positionImportVo.getTstatus()), "职位状态不能为空");
    String parentCode = positionImportVo.getParentCode();
    String positionLevelCode = positionImportVo.getPositionLevelCode();
    PositionVo positionVo = new PositionVo();
    positionVo.setCode(positionImportVo.getCode());
    positionVo.setName(positionImportVo.getName());
    // 职位状态
    NormalStatusEnum normalStatusEnum = NormalStatusEnum.valueOfDesc(positionImportVo.getTstatus());
    if(normalStatusEnum != null) {
      positionVo.setTstatus(normalStatusEnum.getStatus());
    }
    if(StringUtils.isNotBlank(parentCode)){
      PositionVo parent = this.positionService.findByCode(parentCode);
      positionVo.setParent(parent);
    }
    if(StringUtils.isNotBlank(positionLevelCode)){
      PositionLevelVo positionLevelVo = this.positionLevelService.findByCode(positionLevelCode);
      positionVo.setPositionLevel(positionLevelVo);
    }
    return positionVo;
  }

  /**
   * 导入字段校验
   * @param expression
   * @param message
   */
  private void validateTrue(boolean expression, String message) {
    if(!expression) {
      throw new ExcelMigrateException(message);
    }
  }

  /**
   * 导入数据持久化
   * @param positionVo
   * @param params
   */
  @Override
  public void execute(PositionVo positionVo, Map<String, Object> params){
    this.positionService.create(positionVo);
  }
}
