package com.bizunited.platform.user.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.excel.transfer.PositionLevelExportTransfer;
import com.bizunited.platform.user.excel.vo.PositionLevelExportVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 职级导入/导出实现类
 * @Author: chenrong
 * @Date: 2020/10/27 14:36
 */
@Component
public class PositionLevelExportProcess implements FormDetailsExportBoxProcess<PositionLevelExportVo> {

  @Autowired
  private PositionLevelService positionLevelService;
  @Autowired
  private PositionLevelExportTransfer positionLevelExportTransfer;

  /**
   * 导出实现方法
   * @param pageable
   * @param dataViewCode
   * @param exportFiled
   * @param exportParam
   * @param params
   * @return
   */
  @Override
  public Page<PositionLevelExportVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params){
    Page<PositionLevelVo> page = this.positionLevelService.findByConditions(new InvokeParams(), pageable);
    if(page == null || CollectionUtils.isEmpty(page.getContent())){
      return Page.empty(pageable);
    }
    Collection<PositionLevelExportVo> collection = CollectionTransferUtils.transfer(page.getContent(), positionLevelExportTransfer, HashSet.class, ArrayList.class);
    List<PositionLevelExportVo> positionLevelImportAndExportVos = Lists.newArrayList(collection);
    return new PageImpl<>(positionLevelImportAndExportVos, pageable, page.getTotalElements());
  }
}
