package com.bizunited.platform.user.excel.process;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import java.util.Map;

import com.bizunited.platform.user.excel.vo.PositionLevelImportVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 职级导入实现类
 * @Author: chenrong
 * @Date: 2020/10/28 11:26
 */
@Component
public class PositionLevelImportProcess implements FormDetailsImportBoxProcess<PositionLevelVo, PositionLevelImportVo>  {
  @Autowired
  private PositionLevelService positionLevelService;

  /**
   * 导入实现方法
   * @param positionLevelImportVo
   * @param params
   * @param templateCode
   * @param templateVersion
   * @return
   */
  public PositionLevelVo process(PositionLevelImportVo positionLevelImportVo, Map<String, Object> params, String templateCode, String templateVersion){
    if(positionLevelImportVo == null) {
      return null;
    }
    this.validateTrue(StringUtils.isNotBlank(positionLevelImportVo.getName()), "职级名称不能为空");
    this.validateTrue(StringUtils.isNotBlank(positionLevelImportVo.getState()), "职级状态不能为空");
    this.validateTrue(StringUtils.isNotBlank(positionLevelImportVo.getCreateUser()), "没有获取到当前登录用户");
    PositionLevelVo positionLevelVo = new PositionLevelVo();
    positionLevelVo.setCode(positionLevelImportVo.getCode());
    positionLevelVo.setName(positionLevelImportVo.getName());
    positionLevelVo.setCreateUser(positionLevelImportVo.getCreateUser());
    positionLevelVo.setModifyUser(positionLevelImportVo.getCreateUser());
    positionLevelVo.setRoleCodeStr(positionLevelImportVo.getRoleCodes());
    // 职级状态
    NormalStatusEnum normalStatusEnum = NormalStatusEnum.valueOfDesc(positionLevelImportVo.getState());
    if(normalStatusEnum != null) {
      positionLevelVo.setState(normalStatusEnum.getStatus());
    }
    return positionLevelVo;
  }

  /**
   * 导入字段校验
   * @param expression
   * @param message
   */
  private void validateTrue(boolean expression, String message) {
    if(!expression) {
      throw new ExcelMigrateException(message);
    }
  }

  /**
   * 导入数据持久化
   * @param positionLevelVo
   * @param params
   */
  public void execute(PositionLevelVo positionLevelVo, Map<String, Object> params){
    if(positionLevelVo == null) {
      return;
    }
    this.positionLevelService.create(positionLevelVo);
  }
}
