package com.bizunited.platform.user.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.transfer.CollectionTransferUtils;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.excel.transfer.UserExportVoTransfer;
import com.bizunited.platform.user.excel.vo.UserExportExcelVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

/**
 * 导出用户数据处理类
 *
 * @Author: hefan
 * @Date: 2020/11/4 21:32
 */
@Service
public class UserExportProcess implements FormDetailsExportBoxProcess<UserExportExcelVo> {

  @Autowired
  private UserService userService;

  /**
   * 用户导出信息处理
   *
   * @param pageable
   * @param dataViewCode
   * @param exportFiled
   * @param exportParam
   * @param params
   * @return 用户导出视图分页信息
   */
  @Override
  public Page<UserExportExcelVo> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params) {
    Map<String, Object> map = new HashMap<>();
    for (Object o : exportParam.orElse(new JSONArray())) {
      JSONObject jsonObject = (JSONObject) o;
      String code = jsonObject.getString("code");
      Object value = jsonObject.get("value");
      map.put(code, value);
    }
    UserVo userVo = JsonUtils.convert(map, UserVo.class);
    //根据入参，查询出db中的数据（视情况，查询其他表的关联信息）
    Page<UserVo> page = this.userService.findByConditions(userVo, pageable);
    //把查出的数据拷贝到ExcelVO集合中
    Collection<UserExportExcelVo> collection = CollectionTransferUtils.transfer(page.getContent(),
        new UserExportVoTransfer(), HashSet.class, ArrayList.class);
    return new PageImpl<>(Lists.newArrayList(collection), pageable, page.getTotalElements());
  }


}
