package com.bizunited.platform.user.excel.transfer;


import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.user.common.enums.OrganizationTypeEnum;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.excel.vo.OrganizationExportVo;
import org.springframework.beans.BeanUtils;


/**
 * 组织机构导出模型转换器
 * @Author: Paul Chan
 * @Date: 2020/10/28 11:25
 */
public class OrganizationExportVoTransfer implements Transfer<OrganizationVo, OrganizationExportVo> {

  @Override
  public OrganizationExportVo transfer(OrganizationVo orgVo) {
    if (orgVo == null) {
      return null;
    }
    OrganizationExportVo exportVo = new OrganizationExportVo();
    exportVo.setCode(orgVo.getCode());
    exportVo.setOrgName(orgVo.getOrgName());
    exportVo.setDescription(orgVo.getDescription());
    OrganizationTypeEnum organizationTypeEnum = OrganizationTypeEnum.valueOfType(orgVo.getType());
    if(organizationTypeEnum != null) {
      exportVo.setTypeName(organizationTypeEnum.getDesc());
    }
    exportVo.setLevel(orgVo.getLevel());
    OrganizationVo parent = orgVo.getParent();
    if (orgVo.getParent() != null) {
      exportVo.setParentCode(parent.getCode());
      exportVo.setParentName(parent.getOrgName());
    }
    return exportVo;
  }

  @Override
  public OrganizationExportVo transfer(OrganizationVo orgVo,Class<? extends OrganizationExportVo> specifyClass) {
    if (orgVo == null || specifyClass == null) {
      return null;
    }

    OrganizationExportVo exportVo = null;
    try {
      exportVo = specifyClass.newInstance();
    } catch (InstantiationException | IllegalAccessException e) {
      throw new IllegalArgumentException("组织机构导出类转换值异常，请联系管理员!");
    }
    BeanUtils.copyProperties(orgVo,exportVo);

    OrganizationTypeEnum organizationTypeEnum = OrganizationTypeEnum.valueOfType(orgVo.getType());
    if(organizationTypeEnum != null) {
      exportVo.setTypeName(organizationTypeEnum.getDesc());
    }

    OrganizationVo parent = orgVo.getParent();
    if (orgVo.getParent() != null) {
      exportVo.setParentCode(parent.getCode());
      exportVo.setParentName(parent.getOrgName());
    }
    return exportVo;
  }

}
