package com.bizunited.platform.user.excel.transfer;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.excel.vo.PositionExportVo;
import org.springframework.stereotype.Component;

/**
 * 职位类转换实现类
 * @Author: chenrong
 * @Date: 2020/11/3 9:24
 */
@Component
public class PositionExportTransfer implements Transfer<PositionVo, PositionExportVo> {
  @Override
  public PositionExportVo transfer(PositionVo positionVo) {
    PositionExportVo positionExportVo = new PositionExportVo();
    positionExportVo.setCode(positionVo.getCode());
    positionExportVo.setName(positionVo.getName());
    positionExportVo.setCreateTime(positionVo.getCreateTime());
    // 职位状态
    NormalStatusEnum normalStatusEnum = NormalStatusEnum.valueOfStatus(positionVo.getTstatus());
    if(normalStatusEnum != null) {
      positionExportVo.setTstatus(normalStatusEnum.getDesc());
    }
    if(positionVo.getParent() != null) {
      positionExportVo.setParentCode(positionVo.getParent().getCode());
      positionExportVo.setParentName(positionVo.getParent().getName());
    }
    if(positionVo.getPositionLevel() != null) {
      positionExportVo.setPositionLevelCode(positionVo.getPositionLevel().getCode());
      positionExportVo.setPositionLevelName(positionVo.getPositionLevel().getName());
    }
    return positionExportVo;
  }
}
