package com.bizunited.platform.user.excel.transfer;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.excel.vo.PositionLevelExportVo;
import org.springframework.stereotype.Component;

/**
 * 职级类转换实现类
 * @Author: chenrong
 * @Date: 2020/11/3 9:39
 */
@Component
public class PositionLevelExportTransfer implements Transfer<PositionLevelVo, PositionLevelExportVo> {

  @Override
  public PositionLevelExportVo transfer(PositionLevelVo positionLevelVo) {
    PositionLevelExportVo positionLevelExportVo = new PositionLevelExportVo();
    positionLevelExportVo.setCode(positionLevelVo.getCode());
    positionLevelExportVo.setCreateTime(positionLevelVo.getCreateTime());
    positionLevelExportVo.setName(positionLevelVo.getName());
    NormalStatusEnum normalStatusEnum = NormalStatusEnum.valueOfStatus(positionLevelVo.getState());
    positionLevelExportVo.setState(normalStatusEnum.getDesc());
    positionLevelExportVo.setRoleCodes(positionLevelVo.getRoleCodeStr());
    return positionLevelExportVo;
  }
}
