package com.bizunited.platform.user.excel.transfer;

import com.bizunited.platform.common.util.transfer.Transfer;
import com.bizunited.platform.user.common.enums.UserGenderEnum;
import com.bizunited.platform.user.common.enums.UserStatusEnum;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.excel.vo.UserExportExcelVo;

import java.util.Objects;

/**
 * UserVo 转换为 UserExportExcelVo 的实现类
 *
 * @Author: hefan
 * @Date: 2020/11/4 21:32
 */
public class UserExportVoTransfer implements Transfer<UserVo, UserExportExcelVo> {

  /**
   * UserVo 转为 UserExportExcelVo
   *
   * @param userVo
   * @return
   */
  @Override
  public UserExportExcelVo transfer(UserVo userVo) {
    // 拷入VO
    UserExportExcelVo userExportExcelVo = new UserExportExcelVo();
    userExportExcelVo.setUserName(userVo.getUserName());
    userExportExcelVo.setAccount(userVo.getAccount());
    userExportExcelVo.setPhone(userVo.getPhone());
    userExportExcelVo.setCreateTime(userVo.getCreateTime());
    userExportExcelVo.setEntryTime(userVo.getEntryTime());
    userExportExcelVo.setLastloginTime(userVo.getLastloginTime());
    this.convertStatus(userVo, userExportExcelVo);
    this.convertGender(userVo, userExportExcelVo);
    return userExportExcelVo;
  }

  /**
   * 用户状态：数字标识转文字
   *
   * @param userVo
   * @param userExportExcelVo
   */
  private void convertStatus(UserVo userVo, UserExportExcelVo userExportExcelVo) {
    Integer useStatus = userVo.getUseStatus();
    UserStatusEnum userStatusEnum = UserStatusEnum.valueOfStatus(useStatus);
    userExportExcelVo.setUseStatus(Objects.nonNull(userStatusEnum) ? userStatusEnum.getDesc() : null);
  }

  /**
   * 用户性别：数字标识转文字
   *
   * @param userVo
   * @param userExportExcelVo
   */
  private void convertGender(UserVo userVo, UserExportExcelVo userExportExcelVo) {
    Integer gender = userVo.getGender();
    UserGenderEnum userGenderEnum = UserGenderEnum.valueOfGender(gender);
    userExportExcelVo.setGender(Objects.nonNull(userGenderEnum) ? userGenderEnum.getDesc() : null);
  }


}
