package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelExport;

import java.io.Serializable;

/**
 * 行政区域导出VO
 * @Author: Paul Chan
 * @Date: 2020/11/2 15:02
 */
@NebulaExcelExport(excelName = "行政区域")
public class AdministrativeRegionExportVo implements Serializable {
  private static final long serialVersionUID = -1001787835124798729L;

  @NebulaExcelColumn(order = 0, title = "名称")
  private String regionName;

  @NebulaExcelColumn(order = 1, title = "编码")
  private String regionCode;

  @NebulaExcelColumn(order = 2, title = "经度")
  private String longitude;

  @NebulaExcelColumn(order = 3, title = "纬度")
  private String latitude;

  @NebulaExcelColumn(order = 4, title = "上级编码")
  private String parentCode;

  @NebulaExcelColumn(order = 5, title = "上级编码")
  private String parentName;

  @NebulaExcelColumn(order = 6, title = "邮编")
  private String email;

  public String getRegionName() {
    return regionName;
  }

  public void setRegionName(String regionName) {
    this.regionName = regionName;
  }

  public String getRegionCode() {
    return regionCode;
  }

  public void setRegionCode(String regionCode) {
    this.regionCode = regionCode;
  }

  public String getLongitude() {
    return longitude;
  }

  public void setLongitude(String longitude) {
    this.longitude = longitude;
  }

  public String getLatitude() {
    return latitude;
  }

  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getParentName() {
    return parentName;
  }

  public void setParentName(String parentName) {
    this.parentName = parentName;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }
}
