package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

import java.io.Serializable;

/**
 * 行政区域导入模型
 * @Author: Paul Chan
 * @Date: 2020/10/29 13:52
 */
@NebulaExcelImport(startRow = 1)
public class AdministrativeRegionImportVo implements Serializable {
  private static final long serialVersionUID = -8747382712647010553L;

  @NebulaExcelColumn(order = 0, title = "名称")
  private String regionName;

  @NebulaExcelColumn(order = 1, title = "编码")
  private String regionCode;

  @NebulaExcelColumn(order = 2, title = "经度")
  private String longitude;

  @NebulaExcelColumn(order = 3, title = "纬度")
  private String latitude;

  @NebulaExcelColumn(order = 4, title = "上级编码")
  private String parentCode;

  @NebulaExcelColumn(order = 5, title = "邮编")
  private String email;

  public String getRegionName() {
    return regionName;
  }

  public void setRegionName(String regionName) {
    this.regionName = regionName;
  }

  public String getRegionCode() {
    return regionCode;
  }

  public void setRegionCode(String regionCode) {
    this.regionCode = regionCode;
  }

  public String getLongitude() {
    return longitude;
  }

  public void setLongitude(String longitude) {
    this.longitude = longitude;
  }

  public String getLatitude() {
    return latitude;
  }

  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }
}
