package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelExport;

import java.io.Serializable;

/**
 * 组织机构导出excel映射模型
 * @Author: Paul Chan
 * @Date: 2020/10/28 10:57
 */
@NebulaExcelExport(excelName = "组织机构")
public class OrganizationExportVo implements Serializable {
  private static final long serialVersionUID = 922214249458625031L;

  /**
   * 组织编码
   */
  @NebulaExcelColumn(order = 0, title = "组织编码")
  protected String code;

  /**
   * 组织名称
   */
  @NebulaExcelColumn(order = 1, title = "组织名称")
  protected String orgName;

  /**
   * 说明
   */
  @NebulaExcelColumn(order = 2, title = "说明")
  protected String description = "";

  /**
   * 上级编码
   */
  @NebulaExcelColumn(order = 3, title = "上级编码")
  protected String parentCode;

  /**
   * 上级名称
   */
  @NebulaExcelColumn(order = 4, title = "上级名称")
  protected String parentName;


  /**
   * 类型
   */
  @NebulaExcelColumn(order = 5, title = "类型")
  protected String typeName;

  /**
   * 层级
   */
  @NebulaExcelColumn(order = 6, title = "层级")
  protected Integer level;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getTypeName() {
    return typeName;
  }

  public void setTypeName(String typeName) {
    this.typeName = typeName;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getParentName() {
    return parentName;
  }

  public void setParentName(String parentOrgName) {
    this.parentName = parentOrgName;
  }
}
