package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

import java.io.Serializable;

/**
 * 组织机构导入的vo
 * @Author: Paul Chan
 * @Date: 2020/10/27 14:53
 */
@NebulaExcelImport(startRow = 1)
public class OrganizationImportVo implements Serializable {
  private static final long serialVersionUID = 1569563640425503468L;

  /**
   * 组织编码
   */
  @NebulaExcelColumn(order = 0, title = "组织编码")
  private String code;

  /**
   * 组织名称
   */
  @NebulaExcelColumn(order = 1, title = "组织名称")
  private String orgName;

  /**
   * 说明
   */
  @NebulaExcelColumn(order = 2, title = "说明")
  private String description = "";

  /**
   * 上级编码
   */
  @NebulaExcelColumn(order = 3, title = "上级编码")
  private String parentCode;

  /**
   * 类型
   */
  @NebulaExcelColumn(order = 4, title = "类型")
  private Integer type;

  /**
   * 层级
   */
  @NebulaExcelColumn(order = 5, title = "层级")
  private Integer level;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }
}
