package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelExport;
import java.io.Serializable;
import java.util.Date;

/**
 * 岗位导入/导出对象
 * @Author: chenrong
 * @Date: 2020/10/27 9:12
 */
@NebulaExcelExport(excelName = "职位导出数据")
public class PositionExportVo implements Serializable {

    private static final long serialVersionUID = 8214317188716237378L;

    /** 职位编码 **/
    @NebulaExcelColumn(title = "职位编码", order = 0)
    private String code;

    /** 职位名称 **/
    @NebulaExcelColumn(title = "职位名称", order = 1)
    private String name;

    /** 父级职位编码 **/
    @NebulaExcelColumn(title = "父级职位编码", order = 2)
    private String parentCode;

    /** 父级职位名称 **/
    @NebulaExcelColumn(title = "父级职位名称", order = 3)
    private String parentName;

    /** 创建时间 **/
    @NebulaExcelColumn(title = "创建时间", order = 4)
    private Date createTime;

    /** 职位状态 **/
    @NebulaExcelColumn(title = "状态", order = 5)
    private String tstatus;

    /** 职级编码 **/
    @NebulaExcelColumn(title = "职级编码", order = 6)
    private String positionLevelCode;

    /** 职级名称 **/
    @NebulaExcelColumn(title = "职级名称", order = 7)
    private String positionLevelName;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getTstatus() {
        return tstatus;
    }

    public void setTstatus(String tstatus) {
        this.tstatus = tstatus;
    }

    public String getPositionLevelCode() {
        return positionLevelCode;
    }

    public void setPositionLevelCode(String positionLevelCode) {
        this.positionLevelCode = positionLevelCode;
    }

    public String getPositionLevelName() {
        return positionLevelName;
    }

    public void setPositionLevelName(String positionLevelName) {
        this.positionLevelName = positionLevelName;
    }
}
