package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;
import java.io.Serializable;

/**
 * 职位导入对象模型
 * @Author: chenrong
 * @Date: 2020/10/28 11:29
 */
@NebulaExcelImport(startRow = 2)
public class PositionImportVo implements Serializable {

  private static final long serialVersionUID = -6786077923909122014L;

  /** 职位编码 **/
  @NebulaExcelColumn(order = 0)
  private String code;

  /** 职位名称 **/
  @NebulaExcelColumn(order = 1)
  private String name;

  /** 父级职位编码 **/
  @NebulaExcelColumn(order = 2)
  private String parentCode;

  /** 父级职位名称 **/
  @NebulaExcelColumn(order = 3)
  private String parentName;

  /** 职位状态 **/
  @NebulaExcelColumn(order = 4)
  private String tstatus;

  /** 职级编码 **/
  @NebulaExcelColumn(order = 5)
  private String positionLevelCode;

  /** 职级名称 **/
  @NebulaExcelColumn(order = 6)
  private String positionLevelName;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getParentName() {
    return parentName;
  }

  public void setParentName(String parentName) {
    this.parentName = parentName;
  }

  public String getTstatus() {
    return tstatus;
  }

  public void setTstatus(String tstatus) {
    this.tstatus = tstatus;
  }

  public String getPositionLevelCode() {
    return positionLevelCode;
  }

  public void setPositionLevelCode(String positionLevelCode) {
    this.positionLevelCode = positionLevelCode;
  }

  public String getPositionLevelName() {
    return positionLevelName;
  }

  public void setPositionLevelName(String positionLevelName) {
    this.positionLevelName = positionLevelName;
  }
}
