package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelExport;
import java.io.Serializable;
import java.util.Date;

/**
 * 职级导出对象模型
 * @Author: chenrong
 * @Date: 2020/10/27 14:24
 */
@NebulaExcelExport(excelName = "职级导出数据")
public class PositionLevelExportVo implements Serializable {

  private static final long serialVersionUID = -6474461960572903591L;

  /** 职级编码 **/
  @NebulaExcelColumn(title = "职级编码", order = 0)
  private String code;

  /** 职级名称 **/
  @NebulaExcelColumn(title = "职级名称", order = 1)
  private String name;

  /** 角色编码数组，逗号分隔 **/
  @NebulaExcelColumn(title = "角色编码", order = 2)
  private String roleCodes;

  /** 角色名称数据，逗号分隔 **/
  @NebulaExcelColumn(title = "角色名称", order = 3)
  private String roleNames;

  /** 职位状态 **/
  @NebulaExcelColumn(title = "职级状态", order = 4)
  private String state;

  /** 创建时间 **/
  @NebulaExcelColumn(title = "创建时间", order = 5)
  private Date createTime;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getRoleCodes() {
    return roleCodes;
  }

  public void setRoleCodes(String roleCodes) {
    this.roleCodes = roleCodes;
  }

  public String getRoleNames() {
    return roleNames;
  }

  public void setRoleNames(String roleNames) {
    this.roleNames = roleNames;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
