package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;
import java.io.Serializable;

/**
 * 职级导入对象模型
 * @Author: chenrong
 * @Date: 2020/10/28 9:33
 */
@NebulaExcelImport(startRow = 2)
public class PositionLevelImportVo implements Serializable {

  private static final long serialVersionUID = 1320918513564753644L;

  /** 职级编码 **/
  @NebulaExcelColumn(order = 0)
  private String code;

  /** 职级名称 **/
  @NebulaExcelColumn(order = 1)
  private String name;

  /** 角色编码数组，逗号分隔 **/
  @NebulaExcelColumn(order = 2)
  private String roleCodes;

  /** 角色名称数据，逗号分隔 **/
  @NebulaExcelColumn(order = 3)
  private String roleNames;

  /** 职位状态 **/
  @NebulaExcelColumn(order = 4)
  private String state;

  /** 创建人账号 **/
  @NebulaExcelColumn(order = 5)
  private String createUser;

  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getRoleCodes() {
    return roleCodes;
  }

  public void setRoleCodes(String roleCodes) {
    this.roleCodes = roleCodes;
  }

  public String getRoleNames() {
    return roleNames;
  }

  public void setRoleNames(String roleNames) {
    this.roleNames = roleNames;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }
}
