package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelExport;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户导出类
 *
 * @Author: hefan
 * @Date: 2020/11/4 21:32
 */
@NebulaExcelExport(excelName = "用户信息导出", sheetName = "用户信息")
public class UserExportExcelVo implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -5401790328913502519L;
  /**
   * 人员姓名
   */
  @NebulaExcelColumn(order = 0, title = "人员姓名")
  private String userName;
  /**
   * 人员性别 0保密，1男 2女
   */
  @NebulaExcelColumn(order = 1, title = "人员性别")
  private String gender;
  /**
   * 用户账号登录信息
   */
  @NebulaExcelColumn(order = 2, title = "用户账号登录信息")
  private String account;
  /**
   * 人员主要联系电话
   */
  @NebulaExcelColumn(order = 3, title = "人员主要联系电话")
  private String phone;
  /**
   * 创建时间
   */
  @NebulaExcelColumn(order = 4, title = "创建时间", format = "yyyy-MM-dd")
  private Date createTime;
  /**
   * 入职时间
   */
  @NebulaExcelColumn(order = 5, title = "入职时间", format = "yyyy-MM-dd")
  private Date entryTime;
  /**
   * 最后一次登录时间
   */
  @NebulaExcelColumn(order = 6, title = "最后一次登录时间", format = "yyyy-MM-dd")
  private Date lastloginTime;
  /**
   * 用户账号状态 1启用 0禁止
   */
  @NebulaExcelColumn(order = 7, title = "用户账号状态")
  private String useStatus;

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public Date getEntryTime() {
    return entryTime;
  }

  public void setEntryTime(Date entryTime) {
    this.entryTime = entryTime;
  }

  public String getGender() {
    return gender;
  }

  public void setGender(String gender) {
    this.gender = gender;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getLastloginTime() {
    return lastloginTime;
  }

  public void setLastloginTime(Date lastloginTime) {
    this.lastloginTime = lastloginTime;
  }

  public String getUseStatus() {
    return useStatus;
  }

  public void setUseStatus(String useStatus) {
    this.useStatus = useStatus;
  }
}
