package com.bizunited.platform.user.excel.vo;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户导入类
 *
 * @Author: hefan
 * @Date: 2020/11/4 21:32
 */
@NebulaExcelImport(startRow = 2)
public class UserImportExcelVo implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 5925205064128804381L;
  /**
   * 人员姓名
   */
  @NebulaExcelColumn(order = 0)
  private String userName;
  /**
   * 人员性别
   */
  @NebulaExcelColumn(order = 1)
  private String genderStr;
  /**
   * 用户账号登录信息
   */
  @NebulaExcelColumn(order = 2)
  private String account;
  /**
   * 人员主要联系电话
   */
  @NebulaExcelColumn(order = 3, regex = "^[1][0-9]{10}$", errorMessage = "电话格式错误")
  private String phone;
  /**
   * 入职时间
   */
  @NebulaExcelColumn(order = 4, format = "yyyy-MM-dd")
  private Date entryTime;

  private Integer gender;


  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public Date getEntryTime() {
    return entryTime;
  }

  public void setEntryTime(Date entryTime) {
    this.entryTime = entryTime;
  }

  public String getGenderStr() {
    return genderStr;
  }

  public void setGenderStr(String genderStr) {
    this.genderStr = genderStr;
  }

  public Integer getGender() {
    return gender;
  }

  public void setGender(Integer gender) {
    this.gender = gender;
  }

}
