package com.bizunited.platform.user.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.user.common.vo.AdministrativeRegionVo;
import com.bizunited.platform.user.service.feign.fallback.AdministrativeRegionFeignClientFallback;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 行政区域的feign远程调用
 * @Author: chenrong
 * @Date: 2020/10/14 13:57
 */
@FeignClient(qualifier = "AdministrativeRegionFeignClient", name = "${user.application.name}", path = "/v1/nebula/regions", fallback = AdministrativeRegionFeignClientFallback.class, configuration = FeignRequestInterceptor.class)
public interface AdministrativeRegionFeignClient {

  @PostMapping("")
  ResponseModel create(@RequestBody AdministrativeRegionVo region);

  /**
   * 根据id查询详情
   * @param id
   * @return
   */
  @GetMapping("/findDetailsById")
  ResponseModel findDetailsById(@RequestParam("id") String id);

  /**
   * 组合查询,返回一个树结构
   * @param regionName
   * @param regionCode
   * @param longitude
   * @param latitude
   * @return
   */
  @GetMapping("/findByConditions")
  ResponseModel findByConditions(@RequestParam("regionName") String regionName,
                                 @RequestParam("regionCode") String regionCode,
                                 @RequestParam("longitude") String longitude,
                                 @RequestParam("latitude") String latitude);

  /**
   * 根据层级查询,结果不包含任何父子关系
   * @param regionLevel
   * @return
   */
  @GetMapping("/findByRegionLevel")
  ResponseModel findByRegionLevel(@RequestParam("regionLevel") @ApiParam("查询条件") Integer regionLevel);

  /**
   * 根据id查询
   * @param id
   * @return
   */
  @GetMapping("/findById")
  ResponseModel findById(@RequestParam("id") String id);


  /**
   * 根据组织ID查询关联的行政区域
   * @param orgId
   * @return
   */
  @GetMapping("findByOrgId")
  ResponseModel findByOrgId(@RequestParam("orgId") String orgId);

  /**
   * 根据父ID查询子区域
   * @param parentId
   * @return
   */
  @GetMapping("findByParent")
  ResponseModel findByParent(@RequestParam("parentId") String parentId);

  /**
   * 根据编码获取行政区域
   * @param code
   * @return
   */
  @GetMapping("findByCode")
  ResponseModel findByCode(@RequestParam("code") String code);

  /**
   * 更新组织机构关联层级
   * @param level
   * @return
   */
  @PatchMapping("updateOrgMappingLevel")
  ResponseModel updateOrgMappingLevel(@RequestParam("level") Integer level);

  /**
   * 获取组织机构关联层级
   * @return
   */
  @GetMapping("findOrgMappingLevel")
  ResponseModel findOrgMappingLevel();
}
