package com.bizunited.platform.user.service.feign;


import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.service.feign.fallback.PositionLevelFeignClientFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 职位级别的feign远程调用
 * @author: weikangning
 * @Date: 2020/8/24 11:00
 */
@FeignClient(qualifier = "PositionLevelFeignClient", name = "${user.application.name}", path = "/v1/nebula/positionLevel", fallback = PositionLevelFeignClientFallback.class, configuration = FeignRequestInterceptor.class)
public interface PositionLevelFeignClient {
  /**
   * @Description: 条件查询分页
   * @Param: code
   * @Param: name
   * @Param: pageable
   * @Return:
   */
  @GetMapping("/findByConditions")
  ResponseModel findByConditions(@RequestParam(name = "name") String name,
                                 @RequestParam(name = "code") String code,
                                 @RequestParam(name = "page") Integer page,
                                 @RequestParam(name = "size") Integer size);

  /**
   * @Description: 新增
   * @Param PositionLevelVo
   * @Return
   */
  @PostMapping("")
  ResponseModel create(@RequestBody PositionLevelVo positionLevelVo);

  /**
   * @Description: 修改
   * @Param PositionLevelVo
   * @Return
   */
  @PatchMapping("update")
  ResponseModel update(@RequestBody PositionLevelVo positionLevelVo);


  /**
   * @Description 禁用一个或多个职位级别
   * @Param:
   * @Return:
   * @Author: weikangning
   * @Date: 2020/8/27 16:43
   */
  @PatchMapping("disableByIds")
  ResponseModel disableByIds(@RequestBody String[] ids);

  /**
   * @Description 启用一个或多个职位级别
   * @Param:
   * @Return:
   * @Author: weikangning
   * @Date: 2020/8/27 17:09
   */
  @PatchMapping("enableByIds")
  ResponseModel enableByIds(@RequestBody String[] ids);

  /**
   * @Description: 逻辑删除一个或多个职位级别
   * @Param:
   * @Return:
   * @Author: weikangning
   * @Date: 2020/8/27 17:27
   */
  @PatchMapping("deleteByIds")
  ResponseModel deleteByIds(@RequestBody String[] ids);

  /**
   * 根据职位级别编码查询
   *
   * @param code
   * @return
   */
  @GetMapping("findByCode")
  ResponseModel findByCode(@RequestParam(name = "code") String code);


  /**
   * @Description: 根据职位级别ID查询
   * @author: weikangning
   * @Param: positionLevelId
   * @Return:
   */
  @GetMapping("findById")
  ResponseModel findById(@RequestParam(name = "id") String id);

  /**
   * 根据删除状态查询
   * @return
   */
  @GetMapping("findAll")
  ResponseModel findAll();
}
