package com.bizunited.platform.user.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.user.common.vo.UserExtentFieldVo;
import com.bizunited.platform.user.service.feign.fallback.UserExtentFieldFeignClientFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 附加字段的feign远程调用
 * @Author: zengxingwang
 * @Date: 2020/4/3 14:06
 */
@FeignClient(qualifier = "UserExtentFieldFeignClient", name = "${user.application.name}", path = "/v1/nebula/field", fallback = UserExtentFieldFeignClientFallback.class, configuration = FeignRequestInterceptor.class)
public interface UserExtentFieldFeignClient {

  /**
   * 配置附加字段
   * @param userExtentFieldVos
   * @return
   */
  @PostMapping("")
  ResponseModel save(@RequestBody List<UserExtentFieldVo> userExtentFieldVos);

  /**
   * 查询所有的配置
   * @return
   */
  @GetMapping("/findAll")
  ResponseModel findAll();
}
