package com.bizunited.platform.user.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 用户关联设定的feign调用接口
 * @Author: Paul Chan
 * @Date: 2020-03-30 23:06
 */
@FeignClient(qualifier = "UserMappingFeignClient", name = "${user.application.name}", path = "/v1/nebula/user/mapping", configuration = FeignRequestInterceptor.class)
public interface UserMappingFeignClient {

  /**
   * 更新用户关联设定
   * @param mappingVo
   */
  @PatchMapping("")
  ResponseModel update(@RequestBody UserMappingVo mappingVo);

  /**
   * 获取用户关联设定
   * @return
   */
  @GetMapping("")
  ResponseModel findOne();
}
