package com.bizunited.platform.user.service.feign.annotations;

import com.bizunited.platform.user.service.feign.configuration.UserFeignServiceAutoConfiguration;
import org.springframework.context.annotation.Import;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 用户服务feign手动启动类，加入此注解表示启动用户的feign调用功能
 * @Author: Paul Chan
 * @Date: 2020-03-24 13:51
 */
@Documented
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.TYPE })
@Import(UserFeignServiceAutoConfiguration.class)
public @interface EnableUserFeignService {


}
