package com.bizunited.platform.user.service.feign.configuration;

import com.bizunited.platform.user.common.service.UserExtentFieldService;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.service.feign.service.internal.OrganizationServiceImpl;
import com.bizunited.platform.user.service.feign.service.internal.PositionLevelServiceImpl;
import com.bizunited.platform.user.service.feign.service.internal.PositionServiceImpl;
import com.bizunited.platform.user.service.feign.service.internal.UserExtentFieldServiceImpl;
import com.bizunited.platform.user.service.feign.service.internal.UserGroupServiceImpl;
import com.bizunited.platform.user.service.feign.service.internal.UserServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * 用户资源中心的本地实现自动化配置
 * @Author: Paul Chan
 * @Date: 2020-03-16 10:14
 */
@Configuration
@EnableFeignClients(basePackages = "com.bizunited.platform.user.service.feign")
@ComponentScan(basePackages = {"com.bizunited.platform.user", "com.bizunited.platform.common"})
public class UserFeignServiceAutoConfiguration {

  @Bean(name="OrganizationService")
  @ConditionalOnMissingBean
  public OrganizationService getOrganizationService() {
    return new OrganizationServiceImpl();
  }
  @Bean(name="PositionService")
  @ConditionalOnMissingBean
  public PositionService getPositionService() {
    return new PositionServiceImpl();
  }
  @Bean(name="UserGroupService")
  @ConditionalOnMissingBean
  public UserGroupService getUserGroupService() {
    return new UserGroupServiceImpl();
  }
  @Bean(name="UserService")
  @ConditionalOnMissingBean
  public UserService getUserService() {
    return new UserServiceImpl();
  }
  @Bean(name="UserExtentFieldService")
  @ConditionalOnMissingBean
  public UserExtentFieldService getUserExtentFieldService() {
    return new UserExtentFieldServiceImpl();
  }
  @Bean(name="PositionLevelService")
  @ConditionalOnMissingBean
  public PositionLevelService getPositionLevelService() {
    return new PositionLevelServiceImpl();
  }

}
