package com.bizunited.platform.user.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.service.feign.OrganizationFeignClient;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Component;

import java.security.Principal;
import java.util.List;

/**
 * 组织机构的feign熔断器
 * @Author: zengxingwang
 * @Date: 2020/3/22 20:18
 */
@Component
public class OrganizationFeignClientFallback implements OrganizationFeignClient {

  /**
   * 添加组织机构
   * @param organization 组织机构相关信息
   * @return
   */
  @Override
  public ResponseModel create(OrganizationVo organization) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改组织机构
   * @param organization 组织机构相关信息
   * @return
   */
  @Override
  public ResponseModel update(OrganizationVo organization) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改组织机构状态---(启用、禁用)
   * @param orgId 组织机构id
   * @return
   */
  @Override
  public ResponseModel updateStatus(String orgId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 批量修改组织机构状态---(禁用)
   * @param orgIds 组织机构ids
   * @return
   */
  @Override
  public ResponseModel disables(String[] orgIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 批量修改组织机构状态---(启用)
   * @param orgIds 组织机构ids
   * @return
   */
  @Override
  public ResponseModel enables(String[] orgIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }
  /**
   * 对一个指定的currentOrgId进行其父级组织机构parentOrgId的绑定操作（原有currentOrgId的父级信息将会被取消）
   * @param currentOrgId
   * @param parentOrgId
   */
  @Override
  public ResponseModel bindParent(String currentOrgId, String parentOrgId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 对一个指定的currentOrgId取消其当前父级关系的绑定信息
   * @param currentOrgId
   */
  @Override
  public ResponseModel unbindParent(String currentOrgId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 该服务方法可以在忽略当前组织机构（currentOrgId）已绑定父级机构的情况下，
   * 重新为当前组织机构绑定一个新的父级机构
   * @param currentOrgId
   * @param parentOrgId
   */
  public ResponseModel reBindParent(String currentOrgId, String parentOrgId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 将指定组织机构（currentOrgId）和指定的一个/多个用户数据编号（userId）形成绑定关系——一个用户只能属于一个组织机构
   * @param currentOrgId
   * @param userIds      指定的一个/多个用户数据编号
   */
  @Override
  public ResponseModel bindUsers(String currentOrgId, String[] userIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  @Override
  public ResponseModel rebindUsers(String currentOrgId, String[] userIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 解除指定用户和指定组织机构的绑定关系
   * @param currentOrgId 指定的组织机构数据库编号
   * @param userId       指定的人员编号
   */
  @Override
  public ResponseModel unbindUsers(String currentOrgId, String[] userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 查询目前没有指定父级组织机构的所有组织机构信息，无论其状态是否正常（status无论什么值）
   * @return
   */
  @Override
  public ResponseModel findByNullParent() {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 查询指定父级组织机构下的所有子级组织机构信息，无论其状态是否正常（status无论什么值）
   * @param parentId
   * @return
   */
  @Override
  public ResponseModel findByParent(String parentId) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 查询指定父级组织机构下的所有子级组织机构信息，并且匹配过滤条件，无论其状态是否正常（status无论什么值）
   * @param parentId
   * @return
   */
  @Override
  public ResponseModel findByParentAndFilterConditions(String parentId,String id ,String code,String orgName) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 查询目前没有指定父级组织机构的所有组织机构信息，并且依据其状态进行查询
   * @param status
   * @return
   */
  @Override
  public ResponseModel findByNullParentAndStatus(Integer status) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 查询指定父级组织机构下的所有子级组织机构信息，并且依据其状态进行查询
   * @param parentId
   * @param status
   * @return
   */
  @Override
  public ResponseModel findByParentAndStatus(String parentId, Integer status) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据组织机构名称，查询这个组织机构以及这个组织（这些组织机构）对应的所有父级、子级结构信息
   * @param orgName 组织机构名称信息
   * @return
   */
  @Override
  public ResponseModel findByOrgName(String orgName) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 查询指定组织下的详细信息，无论其状态是否正常（status无论什么值）
   * @param id 组织机构id
   * @return
   */
  @Override
  public ResponseModel findDetailsById(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询指定组织下的详细信息，无论其状态是否正常（status无论什么值）
   * @param currentOrgId
   * @return
   */
  @Override
  public ResponseModel findUnbindOrgById(String currentOrgId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询所有的组织机构信息，无论其状态是否正常（status无论什么值）
   * @return
   */
  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 预制控件查询，查询用户组织机构相关信息
   * @param userId
   * @return
   */
  @Override
  public ResponseModel findOrgByUserId(String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询用户组织机构相关信息
   * @param ids
   * @return
   */
  @Override
  public ResponseModel findByIds(List<String> ids) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 组织机构-树结构查询-根据指定组织机构ID，查询这个组织机构以及这个组织机构对应的所有子级结构信息
   *
   * @param id 当前组织机构Id
   * @return
   */
  @Override
  public ResponseModel findById(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 组织机构-根据组织机构名称实现模糊查询
   *
   * @param orgName 组织机构名称
   * @return
   */
  @Override
  public ResponseModel findByOrgNameLike(String orgName) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据组织编码查询
   *
   * @param code
   * @return
   */
  @Override
  public ResponseModel findByCode(String code) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据指定的用户信息，查询这个用户所绑定的组织机构信息(一个或者多个)，以及这个组织机构的所有父级组织机构信息
   * 由于这里的构造是无限级别的，所以需要在方法内做递归处理，且直接返回json信息。<p>
   * 注意：这些组织机构的返回信息中，包括了组织机构已经绑定的角色信息。<p>
   * 一定注意该方法和RoleService.findByUserId(String userId)方法在实现逻辑上的区别。
   *
   * @return
   */
  @Override
  public ResponseModel findByUserId(String userId) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 解除指定用户和任意组织机构的绑定关系
   *
   * @param userId
   */
  @Override
  public ResponseModel unbindUser(String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 获取组织的上级组织
   *
   * @param childId
   * @return
   */
  @Override
  public ResponseModel findByChild(String childId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  @Override
  public ResponseModel findMainOrgByUserId(String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  @Override
  public ResponseModel updateUserMainOrg(String userId, String orgId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  @Override
  public ResponseModel findTreeByConditions(String id, String code, String orgName, Integer tstatus) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据登陆人关联的组织查询
   * @param type
   * @return
   */
  @Override
  public ResponseModel findByPrincipal(Integer type, Principal principal) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据登陆人关联的组织和输入层级查询控件
   * @param type
   * @param account
   * @param level
   * @return
   */
  @Override
  public ResponseModel findByTypeAndLevel(Integer type, String account, Integer level) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 组织合并，用指定组织id，去替换被合并的组织id（包括，他关联的子组织，职位，客户，终端），然后被合并的组织被停用
   * @param currentOrgId 指定的组织机构数据库编号
   * @param id       指定的被合并组织编号
   */
  @Override
  public ResponseModel mergeOrgById(String currentOrgId, String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 组织机构-树结构查询-根据指定组织机构ids或者编码集合(必传任一)，查询这个组织机构以及这个组织机构对应的所有子级结构信息
   * @param ids
   * @param codes
   * @return
   */
  @Override
  public ResponseModel findChildrenByIdsOrCodes(String[] ids, String[] codes) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  @Override
  public ResponseModel findByIdStruSelfAndDescendant(String id) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  @Override
  public ResponseModel findByLevel(Integer level) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  @Override
  public ResponseModel bindRegions(String orgId, String[] regionIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  @Override
  public ResponseModel rebindRegions(String orgId, String[] regionIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  @Override
  public ResponseModel unbindRegions(String orgId, String[] regionIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

}
