package com.bizunited.platform.user.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.service.feign.PositionFeignClient;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.security.Principal;
import java.util.List;

/**
 * 岗位的feign熔断器
 * @Author: zengxingwang
 * @Date: 2020/3/22 20:24
 */
@Component
public class PositionFeignClientFallback implements PositionFeignClient {

  /**
   * 按照条件搜索用户
   * @param nameEqual
   * @param tstatus
   * @param flag
   * @param ids
   * @param codes
   * @param name
   * @param userName
   * @param positionLevel
   * @param orgName
   * @param pageNumber
   * @param pageSize
   * @return
   */
  @Override
  public ResponseModel findByConditions(String nameEqual, Integer tstatus, Integer flag, List<String> ids, List<String> codes, String name,
                                        String userName, String positionLevel, String orgName, int pageNumber, int pageSize) {
    Pageable pageable = PageRequest.of(pageNumber, pageSize);
    return new ResponseModel(System.currentTimeMillis(), new PageImpl<>(Lists.newArrayList(), pageable, 0), ResponseCode.E0, null);
  }

  /**
   * 根据ID查询岗位的详细信息，包括相关组织、角色、用户等
   * @param positionId
   * @return
   */
  @Override
  public ResponseModel findDetailsById(String positionId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 添加岗位
   * @param position
   * @return
   */
  @Override
  public ResponseModel create(PositionVo position) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改岗位
   * @param position
   * @return
   */
  @Override
  public ResponseModel update(PositionVo position) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改岗位状态（启用禁用）
   * @param positionId
   * @return
   */
  @Override
  public ResponseModel updateStatus(String positionId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 绑定指定的岗位和指定的组织机构
   * @param orgId
   * @param positionId
   */
  @Override
  public ResponseModel bindOrg(String positionId, String orgId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }


  @Override
  public ResponseModel unbindOrg(String positionId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  @Override
  public ResponseModel reBindOrg(String orgId, String positionId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 将指定一个岗位和指定的多个用户形成绑定关系
   * @param userIds
   * @param positionId
   */
  @Override
  public ResponseModel bindUsers(String positionId, String[] userIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 解绑多个用户与某一指定的岗位
   * @param userIds
   * @param positionId
   */
  @Override
  public ResponseModel unbindUsersAndPosition(String positionId, String[] userIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 预制控件查询，查询用户岗位相关信息
   * @param userId
   * @return
   */
  @Override
  public ResponseModel findByUserId(String userId) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 预制控件查询，查询用户岗位相关信息
   * @param userAccount
   * @return
   */
  @Override
  public ResponseModel findByUserAccount(String userAccount) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 查询多个用户岗位相关信息
   * @param ids
   * @return
   */
  @Override
  public ResponseModel findByIds(List<String> ids) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据岗位编码查询
   *
   * @param code
   * @return
   */
  @Override
  public ResponseModel findByCode(String code) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 切换岗位
   *
   * @param positionId
   * @param userId
   * @return
   */
  @Override
  public ResponseModel changePosition(String positionId, String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 查询Redis中主岗位，如果redis中不存在，则默认主岗位为数据库查询的第一条数据，并且将该数据存入redis中
   *
   * @param userId
   * @return
   */
  @Override
  public ResponseModel findMainPositionByUserId(String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 重新解绑某一角色与某一岗位关系
   * @param positionId
   * @param userIds
   * @return
   */
  @Override
  public ResponseModel rebindUsers(String positionId, String[] userIds) {
    Validate.notBlank(positionId, "岗位ID不能为空!");
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 查询所有岗位信息（根据创建时间排序）
   * @return
   */
  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据条件查询所有岗位
   * @param status
   * @return
   */
  @Override
  public ResponseModel findByStatus(Integer status) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据登陆人关联的岗位查询
   * @param type
   * @return
   */
  @Override
  public ResponseModel findByPrincipal(Integer type, Principal principal) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据登陆人关联的岗位和输入层级查询控件
   * @param type
   * @param principal
   * @param level
   * @return
   */
  @Override
  public ResponseModel findByTypeAndLevel(Integer type, Principal principal, Integer level) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据职级创建相关职位
   * @param levelCode
   * @return
   */
  @Override
  public ResponseModel createByPositionLevelCode(String levelCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据组织编码查询职位（包括关联信息）
   * @param orgCode
   * @return
   */
  @Override
  public ResponseModel findDetailsByOrgCode(String orgCode) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据编码查询职位的所有下级信息
   * @param code
   * @return
   */
  @Override
  public ResponseModel findDetailsByCode(String code) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据编码查询职位详情，包含组织信息、用户信息
   *
   * @param code
   * @return
   */
  @Override
  public ResponseModel findPositionDetailByCode(String code) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据职级批量查询关联的职位
   *
   * @param positionLevelIds 职级主键列表
   * @return
   */
  @Override
  public ResponseModel findByPositionLevelIds(String[] positionLevelIds) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据职位Id批量禁用职位
   *
   * @param ids 职位Id列表
   */
  @Override
  public ResponseModel disableByIds(String[] ids) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据职位Id批量启用职位
   *
   * @param ids 职位Id列表
   */
  @Override
  public ResponseModel enableByIds(String[] ids) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  @Override
  public ResponseModel reBindOrgCode(String[] codes, String orgCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据职级分页查询职位，带出用户拓展以及组织
   * @param name
   * @param orgName
   * @param userName
   * @param positionLevel
   * @param page
   * @param size
   * @return
   */
  @Override
  public ResponseModel findByPositionLevelAndConditions(String name, String orgName, String userName, String positionLevel, int page, int size) {
    return new ResponseModel(System.currentTimeMillis(), Page.empty(PageRequest.of(page, size)), ResponseCode.E0, null);
  }

  @Override
  public ResponseModel findByUserIdStruDescendant(String userId) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  @Override
  public ResponseModel bindParent(String id, String parentId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }
}
