package com.bizunited.platform.user.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.bizunited.platform.user.service.feign.PositionLevelFeignClient;
import com.google.common.collect.Lists;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 职位级别的熔断器
 * @author: weikangning
 * @Date: 2020/8/24 14:38
 */
@Component
public class PositionLevelFeignClientFallback implements PositionLevelFeignClient {

  /**
   * @Description: 分页条件查询
   * @author: weikangning
   * @Param:
   * @Return:
   */

  @Override
  public ResponseModel findByConditions(String name, String code, Integer page, Integer size) {
    Pageable pageable = PageRequest.of(page, size);
    return new ResponseModel(System.currentTimeMillis(), new PageImpl<>(Lists.newArrayList(), pageable, 0), ResponseCode.E0, null);
  }


  /**
   * @Description: 新建职位级别
   * @author: weikangning
   * @Param:
   * @Return:
   */

  @Override
  public ResponseModel create(PositionLevelVo positionLevelVo) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }


  /**
   * @Description: 更新职位级别
   * @author: weikangning
   * @Param:
   * @Return:
   */

  @Override
  public ResponseModel update(PositionLevelVo positionLevelVo) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * @Description: 禁用一个或多个职位级别
   * @Param:
   * @Return:
   * @Author: weikangning
   * @Date: 2020/8/28 14:23
   */
  @Override
  public ResponseModel disableByIds(String[] positionLevelIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * @Description： 启用一个或多个职位级别
   * @Param:
   * @Return:
   * @Author: weikangning
   * @Date: 2020/8/28 14:23
   */
  @Override
  public ResponseModel enableByIds(String[] positionLevelIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 逻辑删除一个或者多个职位级别
   * @param ids
   * @return
   */
  @Override
  public ResponseModel deleteByIds(String[] ids) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }


  /**
   * @Description: 通过职位级别编码查询
   * @author: weikangning
   * @Param:
   * @Return:
   */

  @Override
  public ResponseModel findByCode(String code) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }


  /**
   * @Description: 通过职位级别ID查询
   * @author: weikangning
   * @Param:
   * @Return:
   */
  @Override
  public ResponseModel findById(String positionLevelId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }


  /**
   * 根据删除状态查询
   * @return
   */
  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }
}
