package com.bizunited.platform.user.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.vo.UserExtentFieldVo;
import com.bizunited.platform.user.service.feign.UserExtentFieldFeignClient;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 附加字段的feign熔断器
 * @Author: zengxingwang
 * @Date: 2020/4/3 14:13
 */
@Component
public class UserExtentFieldFeignClientFallback implements UserExtentFieldFeignClient {

  /**
   * 配置附加字段
   * @param userExtentFieldVos
   * @return
   */
  @Override
  public ResponseModel save(List<UserExtentFieldVo> userExtentFieldVos) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 查询所有的配置
   * @return
   */
  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }
}
