package com.bizunited.platform.user.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.user.service.feign.UserFeignClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * 用户的feign熔断器
 * @Author: zengxingwang
 * @Date: 2020/3/22 20:20
 */
@Component
public class UserFeignClientFallback implements UserFeignClient {

  /**
   * 添加一个新的用户信息（后台管理人员，业务功能操作者）
   * @param user
   * @return
   */
  @Override
  public ResponseModel create(UserVo user) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 修改一个已经存在的用户信息
   * @param user
   * @return
   */
  @Override
  public ResponseModel update(UserVo user) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 重置指定用户的密码信息
   * @param userId
   * @param newPassword 没有经过加密的新的密码
   * @param oldPassword 没有经过加密的原始密码
   * @return
   */
  @Override
  public ResponseModel updatePassword(String userId, String oldPassword, String newPassword) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 修改指定用户的密码信息
   * @param userId
   * @param newPassword 没有经过加密的新的密码
   * @return
   */
  @Override
  public ResponseModel updatePasswordIgnoreOld(String userId, String newPassword) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据账号修改状态
   * @param account
   * @param flag
   * @return
   */
  @Override
  public ResponseModel updateStatus(String account, boolean flag) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询当前用户信息，且包括当前用户已经绑定（包括间接绑定）的角色信息、用户组、组织机构和岗位
   * @param userId 指定的用户id
   * @return
   */
  @Override
  public ResponseModel findDetailsById(String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询当前用户信息(按照用户账号查询)，不包括当前用户已经绑定（包括间接绑定）的角色信息、用户组、组织机构和岗位
   * @param account 账户名
   * @return
   */
  @Override
  public ResponseModel findByAccount(String account) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询登录用户信息
   * @return
   */
  @Override
  public ResponseModel findByPrincipal() {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 预制控件查询，暂时查询当前操作用户基础信息
   * @param userId
   * @return
   */
  @Override
  public ResponseModel findByUserId(String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 按照条件搜索用户，支持模糊查询
   * @param userName
   * @param account
   * @param idcard
   * @param phone
   * @param createTime
   * @param entryTime
   * @param lastloginTime
   * @param useStatus
   * @param userHead
   * @param gender
   * @param extend1
   * @param extend2
   * @param extend3
   * @param extend4
   * @param extend5
   * @param extend6
   * @param extend7
   * @param extend8
   * @param extend9
   * @param extend10
   * @param page
   * @param size
   * @return
   */
  @Override
  public ResponseModel findByConditions(String userName, String account, String idcard, String phone, Date createTime, Date entryTime, Date lastloginTime, Integer useStatus, String userHead, Integer gender, String extend1, String extend2, String extend3, String extend4, String extend5, String extend6, String extend7, String extend8, String extend9, String extend10, Integer page, Integer size) {
    Pageable pageable = PageRequest.of(page, size);
    return new ResponseModel(System.currentTimeMillis(), new PageImpl<>(Lists.newArrayList(), pageable, 0), ResponseCode.E0, null);
  }

  /**
   * 查询多个用户信息
   * @param ids
   * @return
   */
  @Override
  public ResponseModel findByIds(List<String> ids) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据用户账号与名称模糊查询
   * @param param
   * @return
   */
  @Override
  public ResponseModel findByAccountLikeOrNameLike(String param) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 按照指定的手机号，查询账户基本信息，该方法的查询不包括任何关联信息，例如角色信息。
   *
   * @param phone 指定的用户手机号
   * @return
   */
  @Override
  public ResponseModel findByPhone(String phone) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 用户启用
   *
   * @param account
   * @return
   */
  @Override
  public ResponseModel enabled(String account) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 用户禁用
   *
   * @param account
   * @return
   */
  @Override
  public ResponseModel disable(String account) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 成功登陆后，更新用户最后一次登录时间
   *
   * @param account 按照用户账号更新
   */
  @Override
  public ResponseModel updateLastloginTime(String account) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  @Override
  public ResponseModel findByOrgId(String orgId) {
    return new ResponseModel(System.currentTimeMillis(), Sets.newHashSet(), ResponseCode.E0, null);
  }

  @Override
  public ResponseModel findByPositionId(String positionId) {
    return new ResponseModel(System.currentTimeMillis(), Sets.newHashSet(), ResponseCode.E0, null);
  }

  @Override
  public ResponseModel findByAccountAndTypeStruDescendant(String account, Integer type) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  @Override
  public ResponseModel isDefaultPassword(String account) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

}
