package com.bizunited.platform.user.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.service.feign.UserGroupFeignClient;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户组的feign熔断器
 * @Author: zengxingwang
 * @Date: 2020/3/22 20:22
 */
@Component
public class UserGroupFeignClientFallback implements UserGroupFeignClient {

  /**
   * 根据指定用户组名称、状态查询
   * @param groupName
   * @param status
   * @param page
   * @param size
   * @return
   */
  @Override
  public ResponseModel findByCondition(String groupName, String groupCode, Integer status, Integer page, Integer size) {
    Pageable pageable = PageRequest.of(page, size);
    return new ResponseModel(System.currentTimeMillis(), new PageImpl<>(Lists.newArrayList(), pageable, 0), ResponseCode.E0, null);
  }

  /**
   * 新增用户组
   * @param userGroup 用户组信息
   * @return
   */
  @Override
  public ResponseModel create(UserGroupVo userGroup) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改用户组
   * @param userGroupVo 用户组相关信息
   * @return
   */
  @Override
  public ResponseModel update(UserGroupVo userGroupVo) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改用户组状态
   * @param groupId 用户组id
   * @return
   */
  @Override
  public ResponseModel updateStatus(String groupId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 用户与用户组绑定
   * @param groupId 用户组id
   * @param userIds 用户id
   */
  @Override
  public ResponseModel bindUser(String groupId, String[] userIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 用户与用户组解除绑定
   * @param groupId 用户组id
   * @param userIds  用户id
   */
  @Override
  public ResponseModel unBindUser(String groupId, String[] userIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 用户组与角色绑定
   * @param groupId 用户组id
   * @param roleIds  角色id
   */
  @Override
  public ResponseModel bindRole(String groupId, String[] roleIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 用户组与角色解除绑定
   * @param groupId 用户组id
   * @param roleIds  角色id
   */
  @Override
  public ResponseModel unBindRole(String groupId, String[] roleIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 查询指定用户组的基本详情
   * @param id 用户组id
   * @return
   */
  @Override
  public ResponseModel findDetailsById(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询多个用户组基本信息
   * @param ids
   * @return
   */
  @Override
  public ResponseModel findByIds(List<String> ids) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 根据分组名称查询
   *
   * @param groupName
   * @return
   */
  @Override
  public ResponseModel findByGroupName(String groupName) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 查询所有用户组信息（根据创建时间排序）
   *
   * @return
   */
  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }

  /**
   * 按照指定的人员数据库编号，查询人员已经绑定的一个或者多个用户组信息。<p>
   * 注意：用户组信息中包括了用户组已经绑定的角色信息。
   *
   * @param userId
   * @return
   */
  @Override
  public ResponseModel findByUserId(String userId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据编码查询用户组
   * @param code
   * @return
   */
  @Override
  public ResponseModel findByCode(String code) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 用户与用户组的重新绑定
   * @param groupId
   * @param userIds
   * @return
   */
  @Override
  public ResponseModel reBindUser(String groupId, String[] userIds) {
    Validate.notBlank(groupId, "用户与用户组的重新绑定时，用户组id不能为空");
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据用户组编码查询多个用户组信息
   * @param groupCodes
   * @return
   */
  @Override
  public ResponseModel findByGroupCodes(List<String> groupCodes) {
    return new ResponseModel(System.currentTimeMillis(), Lists.newArrayList(), ResponseCode.E0, null);
  }
}
