package com.bizunited.platform.user.service.feign.fallback;


import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.user.common.vo.UserMappingVo;
import com.bizunited.platform.user.service.feign.UserMappingFeignClient;
import org.springframework.stereotype.Component;

/**
 * 用户关联设定的feign调用接口的熔断实现
 * @Author: Paul Chan
 * @Date: 2020-03-30 23:08
 */
@Component
public class UserMappingFeignClientFallback implements UserMappingFeignClient {

  /**
   * 更新用户关联设定
   * @param mappingVo
   */
  @Override
  public ResponseModel update(UserMappingVo mappingVo) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 获取用户关联设定
   * @return
   */
  @Override
  public ResponseModel findOne() {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }
}
