package com.bizunited.platform.user.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.user.common.service.UserExtentFieldService;
import com.bizunited.platform.user.common.vo.UserExtentFieldVo;
import com.bizunited.platform.user.service.feign.UserExtentFieldFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 附加字段的接口实现
 * @Author: zengxingwang
 * @Date: 2020/4/3 14:02
 */
public class UserExtentFieldServiceImpl implements UserExtentFieldService {

  @Autowired
  private UserExtentFieldFeignClient userExtentFieldFeignClient;

  /**
   * 配置附加字段
   * @param userExtentFieldVos
   * @return
   */
  @Override
  public List<UserExtentFieldVo> save(List<UserExtentFieldVo> userExtentFieldVos) {
    this.validateUserExtentField(userExtentFieldVos);
    ResponseModel response = userExtentFieldFeignClient.save(userExtentFieldVos);
    Validate.isTrue(response.getSuccess(), response.getErrorMsg());
    return JsonUtils.convert(response.getSuccessDataOrElse(Lists.newArrayList()), new TypeReference<List<UserExtentFieldVo>>() {});
  }

  /**
   * 查询所有的配置
   * @return
   */
  @Override
  public List<UserExtentFieldVo> findAll() {
    ResponseModel response = userExtentFieldFeignClient.findAll();
    return JsonUtils.convert(response.getSuccessDataOrElse(Lists.newArrayList()), new TypeReference<List<UserExtentFieldVo>>() {});
  }


  /**
   * 验证每一条配置
   * @param userExtentFieldVos
   */
  private void validateUserExtentField(List<UserExtentFieldVo> userExtentFieldVos) {
    Validate.notEmpty(userExtentFieldVos, "配置字段信息不能为空，请检查");
    for(UserExtentFieldVo userExtentFieldVo : userExtentFieldVos){
      Validate.notBlank(userExtentFieldVo.getFieldName(), "字段名称不能为空");
      Validate.notBlank(userExtentFieldVo.getFieldComment(), "字段描述不能为空");
      Validate.notNull(userExtentFieldVo.getState(), "状态不能为空");
      Validate.notNull(userExtentFieldVo.getShowSearch(), "显示框状态不能为空");
      Validate.notNull(userExtentFieldVo.getRequired(), "是否必填不能为空");
    }
  }
}
